/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.instance;

import com.orion.lang.define.StreamEntry;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.collect.Lists;
import com.orion.lang.utils.io.Files1;
import com.orion.net.ftp.client.FtpFile;
import com.orion.net.ftp.client.FtpFileFilter;
import com.orion.net.ftp.client.FtpMessage;
import com.orion.net.ftp.client.Ftps;
import com.orion.net.ftp.client.config.FtpConfig;
import com.orion.net.ftp.client.instance.IFtpInstance;
import com.orion.net.ftp.client.pool.FtpClientPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public abstract class BaseFtpInstance
implements IFtpInstance {
    protected static final String SEPARATOR = "/";
    protected FTPClient client;
    protected FtpConfig config;
    protected FtpClientPool pool;
    protected int bufferSize;

    public BaseFtpInstance(FtpClientPool pool) {
        this.pool = pool;
        this.client = pool.getClient();
        this.config = pool.getConfig();
        this.bufferSize = 8192;
    }

    public BaseFtpInstance(FTPClient client, FtpConfig config) {
        this.client = client;
        this.config = config;
        this.bufferSize = 8192;
    }

    @Override
    public int replyCode() {
        return this.client.getReplyCode();
    }

    @Override
    public String replyMsg() {
        return FtpMessage.REPLY_CODE.get(this.client.getReplyCode());
    }

    @Override
    public boolean reply() {
        return FTPReply.isPositiveCompletion((int)this.client.getReplyCode());
    }

    @Override
    public int read(String file, byte[] bs) throws IOException {
        return this.read(file, 0L, bs, 0, bs.length);
    }

    @Override
    public int read(String file, long skip, byte[] bs) throws IOException {
        return this.read(file, skip, bs, 0, bs.length);
    }

    @Override
    public int read(String file, byte[] bs, int off, int len) throws IOException {
        return this.read(file, 0L, bs, off, len);
    }

    @Override
    public String readLine(String file) throws IOException {
        return this.readLine(file, 0L);
    }

    @Override
    public List<String> readLines(String file) throws IOException {
        return this.readLines(file, 0L, -1);
    }

    @Override
    public List<String> readLines(String file, long skip) throws IOException {
        return this.readLines(file, skip, -1);
    }

    @Override
    public List<String> readLines(String file, int lines) throws IOException {
        return this.readLines(file, 0L, lines);
    }

    @Override
    public long transfer(String path, OutputStream out) throws IOException {
        return this.doTransfer(path, out, 0L, -1, false);
    }

    @Override
    public long transfer(String path, OutputStream out, long skip) throws IOException {
        return this.doTransfer(path, out, skip, -1, false);
    }

    @Override
    public long transfer(String path, OutputStream out, long skip, int size) throws IOException {
        return this.doTransfer(path, out, skip, size, false);
    }

    @Override
    public long transfer(String path, String file) throws IOException {
        Files1.touch((String)file);
        return this.doTransfer(path, Files1.openOutputStream((String)file), 0L, -1, true);
    }

    @Override
    public long transfer(String path, File file) throws IOException {
        Files1.touch((File)file);
        return this.doTransfer(path, Files1.openOutputStream((File)file), 0L, -1, true);
    }

    @Override
    public long transfer(String path, String file, long skip) throws IOException {
        Files1.touch((String)file);
        return this.doTransfer(path, Files1.openOutputStream((String)file), skip, -1, true);
    }

    @Override
    public long transfer(String path, File file, long skip) throws IOException {
        Files1.touch((File)file);
        return this.doTransfer(path, Files1.openOutputStream((File)file), skip, -1, true);
    }

    protected abstract long doTransfer(String var1, OutputStream var2, long var3, int var5, boolean var6) throws IOException;

    @Override
    public void write(String path, InputStream in) throws IOException {
        this.doWrite(path, in, null, null);
    }

    @Override
    public void write(String path, byte[] bs) throws IOException {
        this.doWrite(path, null, new StreamEntry(bs), null);
    }

    @Override
    public void write(String path, byte[] bs, int off, int len) throws IOException {
        this.doWrite(path, null, new StreamEntry(bs, off, len), null);
    }

    @Override
    public void writeLine(String path, String line) throws IOException {
        this.doWrite(path, null, null, Lists.singleton((Object)line));
    }

    @Override
    public void writeLines(String path, List<String> lines) throws IOException {
        this.doWrite(path, null, null, lines);
    }

    protected abstract void doWrite(String var1, InputStream var2, StreamEntry var3, List<String> var4) throws IOException;

    @Override
    public void append(String path, InputStream in) throws IOException {
        this.doAppend(path, in, null, null);
    }

    @Override
    public void append(String path, byte[] bs) throws IOException {
        this.doAppend(path, null, new StreamEntry(bs), null);
    }

    @Override
    public void append(String path, byte[] bs, int off, int len) throws IOException {
        this.doAppend(path, null, new StreamEntry(bs, off, len), null);
    }

    @Override
    public void appendLine(String path, String line) throws IOException {
        this.doAppend(path, null, null, Lists.singleton((Object)line));
    }

    @Override
    public void appendLines(String path, List<String> lines) throws IOException {
        this.doAppend(path, null, null, lines);
    }

    protected abstract void doAppend(String var1, InputStream var2, StreamEntry var3, List<String> var4) throws IOException;

    @Override
    public void uploadFile(String remoteFile, String localFile) throws IOException {
        this.uploadFile(remoteFile, Files1.openInputStreamSafe((String)localFile), true);
    }

    @Override
    public void uploadFile(String remoteFile, File localFile) throws IOException {
        this.uploadFile(remoteFile, Files1.openInputStreamSafe((File)localFile), true);
    }

    @Override
    public void uploadFile(String remoteFile, InputStream in) throws IOException {
        this.uploadFile(remoteFile, in, false);
    }

    @Override
    public void uploadDir(String remoteDir, File localDir) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    @Override
    public void uploadDir(String remoteDir, String localDir) throws IOException {
        this.uploadDir(remoteDir, localDir, true);
    }

    @Override
    public void uploadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    @Override
    public void downloadFile(String remoteFile, String localFile) throws IOException {
        Files1.touch((String)localFile);
        this.downloadFile(remoteFile, Files1.openOutputStreamSafe((String)localFile), true);
    }

    @Override
    public void downloadFile(String remoteFile, File localFile) throws IOException {
        Files1.touch((File)localFile);
        this.downloadFile(remoteFile, Files1.openOutputStreamSafe((File)localFile), true);
    }

    @Override
    public void downloadFile(String remoteFile, OutputStream out) throws IOException {
        this.downloadFile(remoteFile, out, false);
    }

    @Override
    public void downloadDir(String remoteDir, File localDir) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    @Override
    public void downloadDir(String remoteDir, String localDir) throws IOException {
        this.downloadDir(remoteDir, localDir, true);
    }

    @Override
    public void downloadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    @Override
    public List<FtpFile> listFiles() {
        return this.listFiles("", false, false);
    }

    @Override
    public List<FtpFile> listFiles(boolean child) {
        return this.listFiles("", child, false);
    }

    @Override
    public List<FtpFile> listFiles(boolean child, boolean dir) {
        return this.listFiles("", child, dir);
    }

    @Override
    public List<FtpFile> listFiles(String path) {
        return this.listFiles(path, false, false);
    }

    @Override
    public List<FtpFile> listFiles(String path, boolean child) {
        return this.listFiles(path, child, false);
    }

    @Override
    public List<FtpFile> listFiles(String path, boolean child, boolean dir) {
        String base = this.config.getRemoteRootDir();
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        try {
            FTPFile[] files;
            for (FTPFile file : files = this.client.listFiles(this.serverCharset(base + path))) {
                String t = this.serverCharset(Files1.getPath((String)path, (String)file.getName()));
                if (file.isFile()) {
                    list.add(new FtpFile(t, file));
                    continue;
                }
                if (!file.isDirectory()) continue;
                if (dir) {
                    list.add(new FtpFile(t, file));
                }
                if (!child) continue;
                list.addAll(this.listFiles(t + SEPARATOR, true, dir));
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<FtpFile> listDirs() {
        return this.listDirs("", false);
    }

    @Override
    public List<FtpFile> listDirs(boolean child) {
        return this.listDirs("", child);
    }

    @Override
    public List<FtpFile> listDirs(String dir) {
        return this.listDirs(dir, false);
    }

    @Override
    public List<FtpFile> listDirs(String path, boolean child) {
        String base = this.config.getRemoteRootDir();
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        try {
            FTPFile[] files;
            for (FTPFile file : files = this.client.listFiles(this.serverCharset(base + path))) {
                String t = Files1.getPath((String)path, (String)file.getName());
                if (!file.isDirectory()) continue;
                list.add(new FtpFile(t, file));
                if (!child) continue;
                list.addAll(this.listDirs(Files1.getPath((String)(t + SEPARATOR)), true));
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<FtpFile> listFilesSuffix(String suffix) {
        return this.listFilesSuffix("", suffix, false, false);
    }

    @Override
    public List<FtpFile> listFilesSuffix(String suffix, boolean child) {
        return this.listFilesSuffix("", suffix, child, false);
    }

    @Override
    public List<FtpFile> listFilesSuffix(String suffix, boolean child, boolean dir) {
        return this.listFilesSuffix("", suffix, child, dir);
    }

    @Override
    public List<FtpFile> listFilesSuffix(String path, String suffix) {
        return this.listFilesSuffix(path, suffix, false, false);
    }

    @Override
    public List<FtpFile> listFilesSuffix(String path, String suffix, boolean child) {
        return this.listFilesSuffix(path, suffix, child, false);
    }

    @Override
    public List<FtpFile> listFilesSuffix(String path, String suffix, boolean child, boolean dir) {
        return this.listFilesSearch(path, FtpFileFilter.suffix(suffix), child, dir);
    }

    @Override
    public List<FtpFile> listFilesMatch(String match) {
        return this.listFilesMatch("", match, false, false);
    }

    @Override
    public List<FtpFile> listFilesMatch(String match, boolean child) {
        return this.listFilesMatch("", match, child, false);
    }

    @Override
    public List<FtpFile> listFilesMatch(String match, boolean child, boolean dir) {
        return this.listFilesMatch("", match, child, dir);
    }

    @Override
    public List<FtpFile> listFilesMatch(String path, String match) {
        return this.listFilesMatch(path, match, false, false);
    }

    @Override
    public List<FtpFile> listFilesMatch(String path, String match, boolean child) {
        return this.listFilesMatch(path, match, child, false);
    }

    @Override
    public List<FtpFile> listFilesMatch(String path, String match, boolean child, boolean dir) {
        return this.listFilesSearch(path, FtpFileFilter.match(match), child, dir);
    }

    @Override
    public List<FtpFile> listFilesPattern(Pattern pattern) {
        return this.listFilesPattern("", pattern, false, false);
    }

    @Override
    public List<FtpFile> listFilesPattern(Pattern pattern, boolean child) {
        return this.listFilesPattern("", pattern, child, false);
    }

    @Override
    public List<FtpFile> listFilesPattern(Pattern pattern, boolean child, boolean dir) {
        return this.listFilesPattern("", pattern, child, dir);
    }

    @Override
    public List<FtpFile> listFilesPattern(String path, Pattern pattern) {
        return this.listFilesPattern(path, pattern, false, false);
    }

    @Override
    public List<FtpFile> listFilesPattern(String path, Pattern pattern, boolean child) {
        return this.listFilesPattern(path, pattern, child, false);
    }

    @Override
    public List<FtpFile> listFilesPattern(String path, Pattern pattern, boolean child, boolean dir) {
        return this.listFilesSearch(path, FtpFileFilter.pattern(pattern), child, dir);
    }

    @Override
    public List<FtpFile> listFilesFilter(FtpFileFilter filter) {
        return this.listFilesFilter("", filter, false, false);
    }

    @Override
    public List<FtpFile> listFilesFilter(FtpFileFilter filter, boolean child) {
        return this.listFilesFilter("", filter, child, false);
    }

    @Override
    public List<FtpFile> listFilesFilter(FtpFileFilter filter, boolean child, boolean dir) {
        return this.listFilesFilter("", filter, child, dir);
    }

    @Override
    public List<FtpFile> listFilesFilter(String path, FtpFileFilter filter) {
        return this.listFilesFilter(path, filter, false, false);
    }

    @Override
    public List<FtpFile> listFilesFilter(String path, FtpFileFilter filter, boolean child) {
        return this.listFilesFilter(path, filter, child, false);
    }

    @Override
    public List<FtpFile> listFilesFilter(String path, FtpFileFilter filter, boolean child, boolean dir) {
        return this.listFilesSearch(path, filter, child, dir);
    }

    protected abstract List<FtpFile> listFilesSearch(String var1, FtpFileFilter var2, boolean var3, boolean var4);

    @Override
    public boolean pending() throws IOException {
        return this.client.completePendingCommand();
    }

    @Override
    public void restartOffset(long offset) {
        this.client.setRestartOffset(offset);
    }

    @Override
    public void reset() {
        this.client.setRestartOffset(0L);
    }

    @Override
    public String getSystemType() {
        try {
            return this.client.getSystemType();
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public String getStatus() {
        try {
            return this.client.getStatus();
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public String getStatus(String path) {
        try {
            return this.client.getStatus(new String(Strings.bytes((String)Files1.getPath((String)this.config.getRemoteRootDir(), (String)path)), this.config.getRemoteFileNameCharset()));
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public FtpConfig getConfig() {
        return this.config;
    }

    @Override
    public FtpClientPool getPool() {
        return this.pool;
    }

    @Override
    public boolean sendNoop() throws IOException {
        return this.client.sendNoOp();
    }

    @Override
    public String serverCharset(String chars) {
        return new String(Strings.bytes((String)Files1.getPath((String)chars)), this.config.getRemoteFileNameCharset());
    }

    @Override
    public String localCharset(String chars) {
        return new String(Strings.bytes((String)Files1.getPath((String)chars)), this.config.getLocalFileNameCharset());
    }

    public void destroy() {
        Ftps.destroy(this.client);
    }

    public void close() {
        if (this.pool != null) {
            this.pool.returnClient(this.client);
        } else {
            Ftps.destroy(this.client);
        }
    }
}

