/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.bigfile;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.transfer.BaseFileUploader;
import com.orion.net.ftp.client.FtpFile;
import com.orion.net.ftp.client.instance.FtpInstance;
import com.orion.net.ftp.client.instance.IFtpInstance;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class FtpUploader
extends BaseFileUploader {
    private static final String LOCK_SUFFIX = "ofu";
    private final IFtpInstance instance;
    private OutputStream out;

    public FtpUploader(FtpInstance instance, String remote, String local) {
        this(instance, remote, new File(local));
    }

    public FtpUploader(FtpInstance instance, String remote, File local) {
        super(remote, local, LOCK_SUFFIX, instance.getConfig().getBuffSize());
        Valid.notNull((Object)instance, (String)"ftp instance is null", (Object[])new Object[0]);
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            IFtpInstance iFtpInstance = this.instance;
            synchronized (iFtpInstance) {
                super.startUpload();
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((String)("ftp upload exception local file: " + this.local.getAbsolutePath() + " -> remote file: " + this.remote), (Throwable)e);
        }
    }

    @Override
    protected long getFileSize() {
        FtpFile remoteFile = this.instance.getFile(this.remote);
        if (remoteFile == null) {
            return -1L;
        }
        return remoteFile.getSize();
    }

    @Override
    protected void initUpload(boolean breakPoint, long skip) throws IOException {
        this.out = this.instance.openOutputStream(this.remote, breakPoint);
    }

    @Override
    protected void write(byte[] bs, int len) throws IOException {
        this.out.write(bs, 0, len);
    }

    @Override
    protected void transferFinish() {
        this.close();
    }

    public void close() {
        try {
            Streams.close((AutoCloseable)this.out);
            if (this.out != null) {
                this.instance.pending();
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void abort() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public IFtpInstance getInstance() {
        return this.instance;
    }
}

