/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.bigfile;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.transfer.BaseFileDownloader;
import com.orion.net.ftp.client.FtpFile;
import com.orion.net.ftp.client.instance.IFtpInstance;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FtpDownloader
extends BaseFileDownloader {
    private static final String LOCK_SUFFIX = "ofd";
    private final IFtpInstance instance;
    private InputStream in;

    public FtpDownloader(IFtpInstance instance, String remote, String local) {
        this(instance, remote, new File(local));
    }

    public FtpDownloader(IFtpInstance instance, String remote, File local) {
        super(remote, local, LOCK_SUFFIX, instance.getConfig().getBuffSize());
        Valid.notNull((Object)instance, (String)"ftp instance is null", (Object[])new Object[0]);
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            IFtpInstance iFtpInstance = this.instance;
            synchronized (iFtpInstance) {
                super.startDownload();
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((String)("ftp download exception remote file: " + this.remote + " -> local file: " + this.local.getAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    protected long getFileSize() {
        FtpFile remoteFile = this.instance.getFile(this.remote);
        if (remoteFile == null) {
            throw Exceptions.notFound((String)"not found download remote file");
        }
        return remoteFile.getSize();
    }

    @Override
    protected void initDownload(boolean breakPoint, long skip) throws IOException {
        this.in = breakPoint ? this.instance.openInputStream(this.remote, skip) : this.instance.openInputStream(this.remote);
    }

    @Override
    protected int read(byte[] bs) throws IOException {
        return this.in.read(bs);
    }

    @Override
    protected void transferFinish() {
        this.close();
    }

    public void close() {
        try {
            Streams.close((AutoCloseable)this.in);
            if (this.in != null) {
                this.instance.pending();
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void abort() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public IFtpInstance getInstance() {
        return this.instance;
    }
}

