/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.base.ssh;

import com.orion.lang.able.Executable;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public interface IRemoteExecutor
extends Executable,
SafeCloseable {
    public void scheduler(ExecutorService var1);

    public void callback(Runnable var1);

    public void transfer(OutputStream var1) throws IOException;

    public void streamHandler(Consumer<InputStream> var1);

    public void write(byte[] var1);

    default public void write(String command) {
        this.write(Strings.bytes((String)command));
    }

    default public void write(String command, String charset) {
        this.write(Strings.bytes((String)command, (String)charset));
    }

    default public void writeLine(String command) {
        this.write(Strings.bytes((String)(command + "\n")));
    }

    default public void writeLine(String command, String charset) {
        this.write(Strings.bytes((String)(command + "\n"), (String)charset));
    }

    default public void interrupt() {
        this.write(new byte[]{3, 10});
    }

    default public void hangUp() {
        this.write(new byte[]{24, 10});
    }

    default public void exit() {
        this.exit(0);
    }

    default public void exit(int code) {
        this.write(Strings.bytes((String)("exit " + code + "\n")));
    }

    public InputStream getInputStream();

    public OutputStream getOutputStream();

    public boolean isRun();

    public boolean isDone();
}

