/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.base.ssh;

import com.orion.lang.define.thread.HookRunnable;
import com.orion.lang.utils.Threads;
import com.orion.net.base.ssh.BaseRemoteExecutor;
import com.orion.net.base.ssh.IShellExecutor;
import com.orion.net.remote.TerminalType;
import java.util.concurrent.ExecutorService;

public abstract class BaseShellExecutor
extends BaseRemoteExecutor
implements IShellExecutor {
    protected String terminalType = TerminalType.XTERM.getType();
    protected int cols = 180;
    protected int rows = 36;
    protected int width = 1366;
    protected int height = 768;

    @Override
    public void terminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    @Override
    public void size(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
    }

    @Override
    public void dpi(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void size(int cols, int rows, int width, int height) {
        this.cols = cols;
        this.rows = rows;
        this.width = width;
        this.height = height;
    }

    protected void listenerStdout() {
        HookRunnable runnable = new HookRunnable(() -> this.streamHandler.accept(this.inputStream), () -> {
            this.done = true;
            if (this.callback != null) {
                this.callback.run();
            }
        }, true);
        Threads.start((Runnable)runnable, (ExecutorService)this.scheduler);
    }

    @Override
    public String getTerminalType() {
        return this.terminalType;
    }

    @Override
    public int getCols() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

