/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.base.ssh;

import com.orion.lang.support.Attempt;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.ssh.IRemoteExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public abstract class BaseRemoteExecutor
implements IRemoteExecutor {
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected Consumer<InputStream> streamHandler;
    protected Runnable callback;
    protected volatile boolean run;
    protected volatile boolean done;
    protected ExecutorService scheduler;

    @Override
    public void scheduler(ExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void callback(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public void transfer(OutputStream out) throws IOException {
        this.streamHandler = Attempt.rethrows(i -> Streams.transfer((InputStream)i, (OutputStream)out));
    }

    @Override
    public void streamHandler(Consumer<InputStream> streamHandler) {
        this.streamHandler = streamHandler;
    }

    @Override
    public void write(byte[] command) {
        try {
            this.outputStream.write(command);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public void close() {
        Streams.close((AutoCloseable)this.inputStream);
        Streams.close((AutoCloseable)this.outputStream);
    }

    @Override
    public boolean isRun() {
        return this.run;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

