/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.base.ssh;

import com.orion.lang.define.thread.HookRunnable;
import com.orion.lang.support.Attempt;
import com.orion.lang.utils.Threads;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.ssh.BaseRemoteExecutor;
import com.orion.net.base.ssh.ICommandExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public abstract class BaseCommandExecutor
extends BaseRemoteExecutor
implements ICommandExecutor {
    protected InputStream errorStream;
    protected InputStream inheritStream;
    protected boolean inherit;
    protected boolean sync;
    protected Consumer<InputStream> errorStreamHandler;

    @Override
    public void inherit() {
        this.inherit = true;
    }

    @Override
    public void sync() {
        this.sync = true;
    }

    @Override
    public void errorStreamHandler(Consumer<InputStream> errorStreamHandler) {
        this.errorStreamHandler = errorStreamHandler;
    }

    @Override
    public void transferError(OutputStream out) throws IOException {
        this.errorStreamHandler = Attempt.rethrows(i -> Streams.transfer((InputStream)i, (OutputStream)out));
    }

    protected void listenerStdoutAndError() {
        HookRunnable runnable = new HookRunnable(() -> {
            if (this.inherit) {
                this.streamHandler.accept(this.inheritStream);
            } else {
                this.streamHandler.accept(this.inputStream);
            }
            if (this.errorStreamHandler != null && !this.inherit) {
                this.errorStreamHandler.accept(this.errorStream);
            }
        }, () -> {
            this.done = true;
            if (this.callback != null) {
                this.callback.run();
            }
        }, true);
        if (this.sync) {
            runnable.run();
        } else {
            Threads.start((Runnable)runnable, (ExecutorService)this.scheduler);
        }
    }

    @Override
    public void close() {
        super.close();
        Streams.close((AutoCloseable)this.errorStream);
        Streams.close((AutoCloseable)this.inheritStream);
    }

    @Override
    public boolean isInherit() {
        return this.inherit;
    }

    @Override
    public InputStream getInheritStream() {
        return this.inheritStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }
}

