/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.base.file.transfer;

import com.orion.lang.support.progress.ByteTransferRateProgress;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.FileLocks;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.transfer.IFileTransfer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BaseFileDownloader
implements IFileTransfer {
    protected String remote;
    protected File local;
    protected FileLocks.NamedFileLock lock;
    protected ByteTransferRateProgress progress;
    protected int bufferSize;

    public BaseFileDownloader(String remote, File local, String lockSuffix, int bufferSize) {
        Valid.notEmpty((String)remote, (String)"download remote file is empty", (Object[])new Object[0]);
        Valid.notNull((Object)local, (String)"local file is null", (Object[])new Object[0]);
        this.remote = remote;
        this.local = local;
        this.bufferSize = bufferSize;
        this.lock = FileLocks.getSuffixFileLock((String)lockSuffix, (File)local);
        this.progress = new ByteTransferRateProgress(0L);
    }

    protected void startDownload() throws IOException {
        boolean error = false;
        try {
            long remoteSize = this.getFileSize();
            this.progress.setEnd(remoteSize);
            if (Files1.isFile((File)this.local)) {
                long localSize = this.local.length();
                if (localSize == remoteSize) {
                    this.lock.unLock();
                    this.progress.startTime(System.currentTimeMillis());
                    this.transferFinish();
                    return;
                }
                if (this.lock.isLocked()) {
                    this.breakPointResume(localSize);
                } else {
                    this.download();
                }
            } else {
                Files1.touch((File)this.local);
                this.download();
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            this.progress.finish(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download() throws IOException {
        this.initDownload(false, 0L);
        this.progress.start();
        this.lock.tryLock();
        BufferedOutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(Files1.openOutputStreamFastSafe((File)this.local), this.bufferSize);
            byte[] bs = new byte[this.bufferSize];
            while ((read = this.read(bs)) != -1) {
                this.progress.accept((long)read);
                ((OutputStream)out).write(bs, 0, read);
            }
            this.lock.unLock();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            this.transferFinish();
            throw throwable;
        }
        Streams.close((AutoCloseable)out);
        this.transferFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void breakPointResume(long skip) throws IOException {
        this.initDownload(true, skip);
        this.progress.setStart(skip);
        this.progress.setCurrent(skip);
        this.progress.start();
        BufferedOutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(Files1.openOutputStreamFastSafe((File)this.local, (boolean)true), this.bufferSize);
            byte[] bs = new byte[this.bufferSize];
            while ((read = this.read(bs)) != -1) {
                this.progress.accept((long)read);
                ((OutputStream)out).write(bs, 0, read);
            }
            this.lock.unLock();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            this.transferFinish();
            throw throwable;
        }
        Streams.close((AutoCloseable)out);
        this.transferFinish();
    }

    protected abstract long getFileSize() throws IOException;

    protected abstract void initDownload(boolean var1, long var2) throws IOException;

    protected abstract int read(byte[] var1) throws IOException;

    protected abstract void transferFinish() throws IOException;

    @Override
    public ByteTransferRateProgress getProgress() {
        return this.progress;
    }
}

