/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.base.file.sftp;

import com.orion.lang.define.StreamEntry;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.collect.Lists;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.sftp.ISftpExecutor;
import com.orion.net.base.file.sftp.SftpErrorMessage;
import com.orion.net.base.file.sftp.SftpFile;
import com.orion.net.base.file.sftp.SftpFileAttributeFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public abstract class BaseSftpExecutor
implements ISftpExecutor {
    protected String charset;
    protected int bufferSize = 32768;

    protected BaseSftpExecutor() {
    }

    @Override
    public void mkdirs(String path) {
        this.doMakeDirs(path, this::mkdir);
    }

    @Override
    public void rm(String path) {
        try {
            SftpFile file = this.getFile(path);
            if (file == null) {
                return;
            }
            if (file.isDirectory()) {
                List<SftpFile> files = this.ll(path);
                for (SftpFile f : files) {
                    if (f.isDirectory()) {
                        this.rm(f.getPath());
                        continue;
                    }
                    this.removeFile(f.getPath());
                }
                this.removeDir(path);
            } else {
                this.removeFile(path);
            }
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void mv(String source, String target) {
        try {
            source = Files1.getPath((String)source);
            target = Files1.getPath((String)target);
            if (target.charAt(0) == '/') {
                if (!this.isSameParentPath(source, target)) {
                    this.mkdirs(Files1.getParentPath((String)target));
                }
                this.doMove(source, Files1.normalize((String)target));
            } else {
                this.doMove(source, Files1.normalize((String)Files1.getPath((String)(source + "/../" + target))));
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public int read(String path, byte[] bs) throws IOException {
        return this.read(path, 0L, bs, 0, bs.length);
    }

    @Override
    public int read(String path, byte[] bs, int offset, int len) throws IOException {
        return this.read(path, 0L, bs, offset, len);
    }

    @Override
    public int read(String path, long skip, byte[] bs) throws IOException {
        return this.read(path, skip, bs, 0, bs.length);
    }

    @Override
    public long transfer(String path, OutputStream out) throws IOException {
        return this.doTransfer(path, out, 0L, -1, false);
    }

    @Override
    public long transfer(String path, OutputStream out, long skip) throws IOException {
        return this.doTransfer(path, out, skip, -1, false);
    }

    @Override
    public long transfer(String path, OutputStream out, long skip, int size) throws IOException {
        return this.doTransfer(path, out, skip, size, false);
    }

    @Override
    public long transfer(String path, String file) throws IOException {
        Files1.touch((String)file);
        return this.doTransfer(path, Files1.openOutputStream((String)file), 0L, -1, true);
    }

    @Override
    public long transfer(String path, File file) throws IOException {
        Files1.touch((File)file);
        return this.doTransfer(path, Files1.openOutputStream((File)file), 0L, -1, true);
    }

    @Override
    public long transfer(String path, String file, long skip) throws IOException {
        Files1.touch((String)file);
        return this.doTransfer(path, Files1.openOutputStream((String)file), skip, -1, true);
    }

    @Override
    public long transfer(String path, File file, long skip) throws IOException {
        Files1.touch((File)file);
        return this.doTransfer(path, Files1.openOutputStream((File)file), skip, -1, true);
    }

    @Override
    public void write(String path, InputStream in) throws IOException {
        this.doWrite(path, in, null, null);
    }

    @Override
    public void write(String path, byte[] bs) throws IOException {
        this.doWrite(path, null, new StreamEntry(bs), null);
    }

    @Override
    public void write(String path, byte[] bs, int off, int len) throws IOException {
        this.doWrite(path, null, new StreamEntry(bs, off, len), null);
    }

    @Override
    public void writeLine(String path, String line) throws IOException {
        this.doWrite(path, null, null, Lists.singleton((Object)line));
    }

    @Override
    public void writeLines(String path, List<String> lines) throws IOException {
        this.doWrite(path, null, null, lines);
    }

    @Override
    public void append(String path, InputStream in) throws IOException {
        this.doAppend(path, in, null, null);
    }

    @Override
    public void append(String path, byte[] bs) throws IOException {
        this.doAppend(path, null, new StreamEntry(bs), null);
    }

    @Override
    public void append(String path, byte[] bs, int off, int len) throws IOException {
        this.doAppend(path, null, new StreamEntry(bs, off, len), null);
    }

    @Override
    public void appendLine(String path, String line) throws IOException {
        this.doAppend(path, null, null, Lists.singleton((Object)line));
    }

    @Override
    public void appendLines(String path, List<String> lines) throws IOException {
        this.doAppend(path, null, null, lines);
    }

    @Override
    public void uploadFile(String remoteFile, String localFile) throws IOException {
        this.uploadFile(remoteFile, Files1.openInputStreamFast((String)localFile), true);
    }

    @Override
    public void uploadFile(String remoteFile, File localFile) throws IOException {
        this.uploadFile(remoteFile, Files1.openInputStreamFast((File)localFile), true);
    }

    @Override
    public void uploadFile(String remoteFile, InputStream in) throws IOException {
        this.uploadFile(remoteFile, in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void uploadFile(String remoteFile, InputStream in, boolean close) throws IOException {
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(in, this.bufferSize);
            this.doWrite(remoteFile, buffer, null, null);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            Streams.close((AutoCloseable)in);
            Streams.close(buffer);
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        Streams.close((AutoCloseable)buffer);
    }

    @Override
    public void uploadDir(String remoteDir, File localDir) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    @Override
    public void uploadDir(String remoteDir, String localDir) throws IOException {
        this.uploadDir(remoteDir, localDir, true);
    }

    @Override
    public void uploadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    @Override
    public void uploadDir(String remoteDir, String localDir, boolean child) throws IOException {
        localDir = Files1.getPath((String)localDir);
        List dirs = Files1.listDirs((String)localDir, (boolean)child);
        List files = Files1.listFiles((String)localDir, (boolean)child);
        for (File dir : dirs) {
            this.mkdirs(Files1.getPath((String)remoteDir, (String)dir.getAbsolutePath().substring(localDir.length())));
        }
        for (File file : files) {
            String path = Files1.getPath((String)remoteDir, (String)file.getAbsolutePath().substring(localDir.length()));
            this.uploadFile(path, file);
        }
    }

    @Override
    public void downloadFile(String remoteFile, String localFile) throws IOException {
        Files1.touch((String)localFile);
        this.downloadFile(remoteFile, Files1.openOutputStreamSafe((String)localFile), true);
    }

    @Override
    public void downloadFile(String remoteFile, File localFile) throws IOException {
        Files1.touch((File)localFile);
        this.downloadFile(remoteFile, Files1.openOutputStreamSafe((File)localFile), true);
    }

    @Override
    public void downloadFile(String remoteFile, OutputStream out) throws IOException {
        this.downloadFile(remoteFile, out, false);
    }

    @Override
    public void downloadFile(String remoteFile, OutputStream out, boolean close) throws IOException {
        this.doTransfer(remoteFile, out, 0L, -1, close);
    }

    @Override
    public void downloadDir(String remoteDir, File localDir) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    @Override
    public void downloadDir(String remoteDir, String localDir) throws IOException {
        this.downloadDir(remoteDir, localDir, true);
    }

    @Override
    public void downloadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    @Override
    public void downloadDir(String remoteDir, String localDir, boolean child) throws IOException {
        remoteDir = Files1.getPath((String)remoteDir);
        if (!child) {
            List<SftpFile> list = this.listFiles(remoteDir, false);
            for (SftpFile s : list) {
                this.downloadFile(s.getPath(), Files1.getPath((String)localDir, (String)Files1.getFileName((String)s.getPath())));
            }
        } else {
            List<SftpFile> list = this.listDirs(remoteDir, true);
            for (SftpFile s : list) {
                Files1.mkdirs((String)Files1.getPath((String)localDir, (String)s.getPath().substring(remoteDir.length())));
            }
            list = this.listFiles(remoteDir, true);
            for (SftpFile s : list) {
                this.downloadFile(s.getPath(), Files1.getPath((String)localDir, (String)s.getPath().substring(remoteDir.length())));
            }
        }
    }

    @Override
    public List<SftpFile> listFiles(String path) {
        return this.listFiles(path, false, false);
    }

    @Override
    public List<SftpFile> listFiles(String path, boolean child) {
        return this.listFiles(path, child, false);
    }

    @Override
    public List<SftpFile> listFiles(String path, boolean child, boolean dir) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            List<SftpFile> ls = this.ll(path);
            for (SftpFile l : ls) {
                if (l.isDirectory()) {
                    if (dir) {
                        list.add(l);
                    }
                    if (!child) continue;
                    list.addAll(this.listFiles(Files1.getPath((String)path, (String)l.getName()), true, dir));
                    continue;
                }
                list.add(l);
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<SftpFile> listDirs(String path) {
        return this.listDirs(path, false);
    }

    @Override
    public List<SftpFile> listDirs(String path, boolean child) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            List<SftpFile> ls = this.ll(path);
            for (SftpFile l : ls) {
                if (!l.isDirectory()) continue;
                list.add(l);
                if (!child) continue;
                list.addAll(this.listDirs(Files1.getPath((String)path, (String)l.getName()), true));
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<SftpFile> listFilesSuffix(String path, String suffix) {
        return this.listFilesSuffix(path, suffix, false, false);
    }

    @Override
    public List<SftpFile> listFilesSuffix(String path, String suffix, boolean child) {
        return this.listFilesSuffix(path, suffix, child, false);
    }

    @Override
    public List<SftpFile> listFilesSuffix(String path, String suffix, boolean child, boolean dir) {
        return this.doListFiles(path, SftpFileAttributeFilter.suffix(suffix), child, dir);
    }

    @Override
    public List<SftpFile> listFilesMatch(String path, String match) {
        return this.listFilesMatch(path, match, false, false);
    }

    @Override
    public List<SftpFile> listFilesMatch(String path, String match, boolean child) {
        return this.listFilesMatch(path, match, child, false);
    }

    @Override
    public List<SftpFile> listFilesMatch(String path, String match, boolean child, boolean dir) {
        return this.doListFiles(path, SftpFileAttributeFilter.match(match), child, dir);
    }

    @Override
    public List<SftpFile> listFilesPattern(String path, Pattern pattern) {
        return this.listFilesPattern(path, pattern, false, false);
    }

    @Override
    public List<SftpFile> listFilesPattern(String path, Pattern pattern, boolean child) {
        return this.listFilesPattern(path, pattern, child, false);
    }

    @Override
    public List<SftpFile> listFilesPattern(String path, Pattern pattern, boolean child, boolean dir) {
        return this.doListFiles(path, SftpFileAttributeFilter.pattern(pattern), child, dir);
    }

    @Override
    public List<SftpFile> listFilesFilter(String path, SftpFileAttributeFilter filter) {
        return this.listFilesFilter(path, filter, false, false);
    }

    @Override
    public List<SftpFile> listFilesFilter(String path, SftpFileAttributeFilter filter, boolean child) {
        return this.listFilesFilter(path, filter, child, false);
    }

    @Override
    public List<SftpFile> listFilesFilter(String path, SftpFileAttributeFilter filter, boolean child, boolean dir) {
        return this.doListFiles(path, filter, child, dir);
    }

    protected abstract void doMove(String var1, String var2);

    protected void doMakeDirs(String path, Consumer<String> creative) {
        SftpFile file = this.getFile(path, false);
        if (file != null && file.isDirectory()) {
            return;
        }
        List parentPaths = Files1.getParentPaths((String)path);
        parentPaths.add(path);
        boolean check = true;
        for (String parentPath : parentPaths) {
            SftpFile parent;
            if (check && ((parent = this.getFile(parentPath, false)) == null || !parent.isDirectory())) {
                check = false;
            }
            if (check) continue;
            try {
                creative.accept(parentPath);
            }
            catch (Exception e) {
                throw Exceptions.sftp((Throwable)e);
            }
        }
    }

    protected abstract long doTransfer(String var1, OutputStream var2, long var3, int var5, boolean var6) throws IOException;

    protected abstract void doWrite(String var1, InputStream var2, StreamEntry var3, List<String> var4) throws IOException;

    protected abstract void doAppend(String var1, InputStream var2, StreamEntry var3, List<String> var4) throws IOException;

    private List<SftpFile> doListFiles(String path, SftpFileAttributeFilter filter, boolean child, boolean dir) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            List<SftpFile> ls = this.ll(path);
            for (SftpFile l : ls) {
                String fn = l.getName();
                boolean isDir = l.isDirectory();
                if ((!isDir || dir) && filter.accept(l)) {
                    list.add(l);
                }
                if (!isDir || !child) continue;
                list.addAll(this.doListFiles(Files1.getPath((String)path, (String)fn), filter, true, dir));
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    protected boolean isSameParentPath(String source, String target) {
        return Files1.getParentPath((String)source).equals(Files1.getParentPath((String)target));
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

