/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.unit;

import java.math.BigDecimal;
import java.math.RoundingMode;

public enum LengthUnit {
    MM{

        @Override
        public BigDecimal toMillimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toCentimeter(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode);
        }

        @Override
        public BigDecimal toDecimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode).divide(TEN, roundingMode);
        }

        @Override
        public BigDecimal toMetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode).divide(HUNDRED, roundingMode);
        }

        @Override
        public BigDecimal toKilometre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode).divide(HUNDRED, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    CM{

        @Override
        public BigDecimal toMillimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(TEN);
        }

        @Override
        public BigDecimal toCentimeter(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toDecimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode);
        }

        @Override
        public BigDecimal toMetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(HUNDRED, roundingMode);
        }

        @Override
        public BigDecimal toKilometre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(HUNDRED, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    DM{

        @Override
        public BigDecimal toMillimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(HUNDRED);
        }

        @Override
        public BigDecimal toCentimeter(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(TEN);
        }

        @Override
        public BigDecimal toDecimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toMetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode);
        }

        @Override
        public BigDecimal toKilometre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(TEN, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    M{

        @Override
        public BigDecimal toMillimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(HUNDRED).multiply(TEN);
        }

        @Override
        public BigDecimal toCentimeter(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(HUNDRED);
        }

        @Override
        public BigDecimal toDecimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(TEN);
        }

        @Override
        public BigDecimal toMetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toKilometre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    KM{

        @Override
        public BigDecimal toMillimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(TEN).multiply(HUNDRED).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toCentimeter(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(HUNDRED).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toDecimetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(TEN).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toMetre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toKilometre(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }
    };

    private static final BigDecimal TEN;
    private static final BigDecimal HUNDRED;
    private static final BigDecimal THOUSAND;
    private static final RoundingMode DEFAULT_ROUND_MODE;
    private static final int DEFAULT_SCALE = 2;

    public BigDecimal toMillimetre(long u) {
        return this.toMillimetre(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toMillimetre(long u, int scale, RoundingMode roundingMode) {
        return this.toMillimetre(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toMillimetre(BigDecimal u) {
        return this.toMillimetre(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toMillimetre(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toCentimeter(long u) {
        return this.toCentimeter(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toCentimeter(long u, int scale, RoundingMode roundingMode) {
        return this.toCentimeter(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toCentimeter(BigDecimal u) {
        return this.toCentimeter(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toCentimeter(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toDecimetre(long u) {
        return this.toDecimetre(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toDecimetre(long u, int scale, RoundingMode roundingMode) {
        return this.toDecimetre(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toDecimetre(BigDecimal u) {
        return this.toDecimetre(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toDecimetre(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toMetre(long u) {
        return this.toMetre(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toMetre(long u, int scale, RoundingMode roundingMode) {
        return this.toMetre(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toMetre(BigDecimal u) {
        return this.toMetre(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toMetre(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toKilometre(long u) {
        return this.toKilometre(BigDecimal.valueOf(u), 2, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toKilometre(long u, int scale, RoundingMode roundingMode) {
        return this.toKilometre(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toKilometre(BigDecimal u) {
        return this.toKilometre(u, 2, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toKilometre(BigDecimal var1, int var2, RoundingMode var3);

    static {
        TEN = BigDecimal.valueOf(10L);
        HUNDRED = BigDecimal.valueOf(100L);
        THOUSAND = BigDecimal.valueOf(1000L);
        DEFAULT_ROUND_MODE = RoundingMode.FLOOR;
    }
}

