/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.time.cron;

import com.orion.lang.utils.time.Dates;
import com.orion.lang.utils.time.cron.Cron;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CronSupport {
    private static final String CRON_FORMAT = "ss mm HH dd MM ? yyyy";

    private CronSupport() {
    }

    public static String getCronExpression(Date date) {
        return Dates.format(date, CRON_FORMAT);
    }

    public static Cron getCron(Date date) {
        return new Cron(Dates.format(date, CRON_FORMAT));
    }

    public static Cron getCron(String expression) {
        return new Cron(expression);
    }

    public static boolean isValidExpression(String expression) {
        try {
            new Cron(expression);
            return true;
        }
        catch (Exception pe) {
            return false;
        }
    }

    public static Date getNextTime(Cron cron) {
        return cron.getNextValidTimeAfter(new Date());
    }

    public static Date getNextTime(Cron cron, Date date) {
        return cron.getNextValidTimeAfter(date);
    }

    public static List<Date> getNextTime(Cron cron, int times) {
        return CronSupport.getNextTime(cron, new Date(), times);
    }

    public static List<Date> getNextTime(Cron cron, Date date, int times) {
        ArrayList<Date> list = new ArrayList<Date>();
        for (int i = 0; i < times && (date = cron.getNextValidTimeAfter(date)) != null; ++i) {
            list.add(date);
        }
        return list;
    }
}

