/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.time;

import com.orion.lang.utils.time.Dates;
import java.util.Calendar;
import java.util.Date;

public class Zodiacs {
    private static final int[] SPLIT_DAY = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] CONSTELLATION = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    private static final String[] CHINESE_ZODIACS = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};

    private Zodiacs() {
    }

    public static String getConstellation() {
        return Zodiacs.getConstellation(Dates.calendar());
    }

    public static String getConstellation(Date date) {
        return Zodiacs.getConstellation(Dates.calendar(date));
    }

    public static String getConstellation(Calendar c) {
        if (c == null) {
            return null;
        }
        return Zodiacs.getConstellation(c.get(2), c.get(5));
    }

    public static String getConstellation(int month, int day) {
        return day < SPLIT_DAY[month] ? CONSTELLATION[month] : CONSTELLATION[month + 1];
    }

    public static String getChineseZodiac() {
        return Zodiacs.getChineseZodiac(Dates.calendar());
    }

    public static String getChineseZodiac(Date date) {
        return Zodiacs.getChineseZodiac(Dates.calendar(date));
    }

    public static String getChineseZodiac(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return Zodiacs.getChineseZodiac(calendar.get(1));
    }

    public static String getChineseZodiac(int year) {
        if (year < 1900) {
            return null;
        }
        return CHINESE_ZODIACS[(year - 1900) % CHINESE_ZODIACS.length];
    }
}

