/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.convert.TypeStore;
import com.orion.lang.utils.reflect.Constructors;
import com.orion.lang.utils.reflect.Methods;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;

public class TypeInfer {
    private TypeInfer() {
    }

    public static <T> T newInstanceInfer(List<Constructor<T>> constructors, Object[] params) {
        int index = -1;
        Class[] sourceClasses = Arrays1.mapper(params, Class[]::new, Object::getClass);
        List<Class<?>[]> targetClassesList = constructors.stream().filter(m -> m.getParameterCount() == params.length).peek(Constructors::setAccessible).map(Constructor::getParameterTypes).collect(Collectors.toList());
        for (int i = 0; i < 3; ++i) {
            if (index != -1) continue;
            index = TypeInfer.allTypeMatch(sourceClasses, targetClassesList, i + 1);
        }
        if (index == -1) {
            throw Exceptions.invoke("could infer new instance, not found match constructor");
        }
        Class[] targetClass = (Class[])targetClassesList.get(index);
        Object[] inferParams = TypeInfer.convertType(params, targetClass);
        return Constructors.newInstance(constructors.get(index), inferParams);
    }

    public static <T> T invokeInfer(Object o, List<Method> methods, Object[] params) {
        int index = -1;
        Class[] sourceClasses = Arrays1.mapper(params, Class[]::new, Object::getClass);
        List<Class<?>[]> targetClassesList = methods.stream().filter(m -> m.getParameterCount() == params.length).peek(Methods::setAccessible).map(Method::getParameterTypes).collect(Collectors.toList());
        for (int i = 0; i < 3; ++i) {
            if (index != -1) continue;
            index = TypeInfer.allTypeMatch(sourceClasses, targetClassesList, i + 1);
        }
        if (index == -1) {
            throw Exceptions.invoke("could infer invoke method, not found match method");
        }
        Class[] targetClass = (Class[])targetClassesList.get(index);
        Object[] inferParams = TypeInfer.convertType(params, targetClass);
        return (T)Methods.invokeMethod(o, methods.get(index), inferParams);
    }

    public static int allTypeMatch(Class<?>[] sourceClasses, List<Class<?>[]> targetClassesList, int type) {
        for (int i = 0; i < targetClassesList.size(); ++i) {
            Class<?>[] targetClasses = targetClassesList.get(i);
            if (targetClasses.length != sourceClasses.length || !TypeInfer.allTypeMatch(sourceClasses, targetClasses, type)) continue;
            return i;
        }
        return -1;
    }

    private static boolean allTypeMatch(Class<?>[] sourceClasses, Class<?>[] targetClasses, int type) {
        for (int i = 0; i < sourceClasses.length; ++i) {
            Class<?> sourceClass = sourceClasses[i];
            Class<?> targetClass = targetClasses[i];
            if (type == 1) {
                if (sourceClass.equals(targetClass)) continue;
                return false;
            }
            if (type == 2) {
                if (TypeStore.canDirectConvert(sourceClass, targetClass)) continue;
                return false;
            }
            if (type == 3) {
                if (TypeStore.canConvert(sourceClass, targetClass)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static Object[] convertType(Object[] sourceArray, Class<?>[] targetClasses) {
        Object[] r = new Object[sourceArray.length];
        for (int i = 0; i < sourceArray.length; ++i) {
            r[i] = TypeStore.STORE.to(sourceArray[i], targetClasses[i]);
        }
        return r;
    }
}

