/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.reflect.Methods;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Jars {
    private Jars() {
    }

    public static URL getTargetUrl() {
        URL resource = Methods.class.getClassLoader().getResource("");
        if (resource == null) {
            resource = Methods.class.getResource("");
        }
        return resource;
    }

    public static JarFile getJarFile() {
        URL targetUrl = Jars.getTargetUrl();
        if (targetUrl != null && "jar".equals(targetUrl.getProtocol())) {
            try {
                return ((JarURLConnection)targetUrl.openConnection()).getJarFile();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static JarFile getJarFile(File file) {
        try {
            return new JarFile(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JarFile getJarFile(URL url) {
        String protocol = url.getProtocol();
        try {
            switch (protocol) {
                case "jar": {
                    return ((JarURLConnection)url.openConnection()).getJarFile();
                }
                case "file": {
                    return new JarFile(url.getFile());
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getClassByJar(String jarPath) {
        Valid.notBlank(jarPath, "jar path is null", new Object[0]);
        try (JarFile jarFile = new JarFile(jarPath);){
            List<String> list = Jars.getClassByJar(jarFile);
            return list;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    public static List<String> getClassByJar(JarFile jarFile) {
        Valid.notNull(jarFile, "jar file is null", new Object[0]);
        ArrayList<String> classes = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String className = entries.nextElement().getName();
            if (!className.endsWith(".class")) continue;
            classes.add(className.replaceAll("/", ".").substring(0, className.lastIndexOf(".")));
        }
        return classes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getSourceByJar(String jarPath) {
        Valid.notBlank(jarPath, "jar path is null", new Object[0]);
        ArrayList<String> sources = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String fileName = entries.nextElement().getName();
                if (fileName.endsWith(".class") || fileName.endsWith("/")) continue;
                sources.add(Files1.getPath(jarPath + "!/" + fileName));
            }
            ArrayList<String> arrayList = sources;
            return arrayList;
        }
        catch (IOException e) {
            return sources;
        }
    }

    public static List<String> getSourceByJar(JarFile jarFile) {
        Valid.notNull(jarFile, "jar file is null", new Object[0]);
        ArrayList<String> sources = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String fileName = entries.nextElement().getName();
            if (fileName.endsWith(".class") || fileName.endsWith("/")) continue;
            sources.add("/" + fileName);
        }
        return sources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getSourceByJar(String jarPath, String suffix) {
        Valid.notBlank(jarPath, "jar path is null", new Object[0]);
        ArrayList<String> sources = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String fileName = entries.nextElement().getName();
                if (suffix == null || !fileName.endsWith(suffix) || fileName.endsWith("/")) continue;
                sources.add(Files1.getPath(jarPath + "!/" + fileName));
            }
            ArrayList<String> arrayList = sources;
            return arrayList;
        }
        catch (IOException e) {
            return sources;
        }
    }

    public static List<String> getSourceByJar(JarFile jarFile, String suffix) {
        Valid.notNull(jarFile, "jar file is null", new Object[0]);
        ArrayList<String> sources = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String fileName = entries.nextElement().getName();
            if (suffix == null || !fileName.endsWith(suffix) || fileName.endsWith("/")) continue;
            sources.add("/" + fileName);
        }
        return sources;
    }
}

