/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.net;

import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Ports {
    private static int timeout = 3000;

    private Ports() {
    }

    public static int getFreePort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            Streams.close(serverSocket);
            return port;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getFreePort(int[] ports) {
        for (int port : ports) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                Streams.close(serverSocket);
                return port;
            }
            catch (Exception exception) {
            }
        }
        return -1;
    }

    public static int getFreePort(int start, int end) {
        Valid.gte(start, 1001, "start port must greater than 1000", new Object[0]);
        Valid.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Valid.gt(end, start, "end port must greater than start", new Object[0]);
        for (int i = start; i <= end; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                Streams.close(serverSocket);
                return i;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return -1;
    }

    public static List<Integer> getFreePorts(int[] ports) {
        ArrayList<Integer> freePorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                Streams.close(serverSocket);
                freePorts.add(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return freePorts;
    }

    public static List<Integer> getFreePorts(int start, int end) {
        Valid.gte(start, 1001, "start port must greater than 1000", new Object[0]);
        Valid.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Valid.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> freePorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                Streams.close(serverSocket);
                freePorts.add(i);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return freePorts;
    }

    public static List<Integer> getUsedPorts(int[] ports) {
        ArrayList<Integer> usedPorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                Streams.close(serverSocket);
            }
            catch (Exception e) {
                usedPorts.add(port);
            }
        }
        return usedPorts;
    }

    public static List<Integer> getUsedPorts(int start, int end) {
        Valid.gte(start, 1001, "start port must greater than 1000", new Object[0]);
        Valid.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Valid.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> usedPorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i);
                Streams.close(serverSocket);
                continue;
            }
            catch (IOException ex) {
                usedPorts.add(i);
            }
        }
        return usedPorts;
    }

    public static boolean isFree(int port) {
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            Streams.close(serverSocket);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isUsed(int port) {
        return Ports.isFree(port);
    }

    public static List<Integer> getOpenPorts(String host, int[] ports) {
        ArrayList<Integer> openPorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                Streams.close(socket);
                openPorts.add(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return openPorts;
    }

    public static List<Integer> getOpenPorts(String host, int start, int end) {
        Valid.gt(start, 0, "start port must greater than 0", new Object[0]);
        Valid.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Valid.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> openPorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, i), timeout);
                Streams.close(socket);
                openPorts.add(i);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return openPorts;
    }

    public static List<Integer> getClosePorts(String host, int[] ports) {
        ArrayList<Integer> closePorts = new ArrayList<Integer>();
        for (int port : ports) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                Streams.close(socket);
            }
            catch (Exception e) {
                closePorts.add(port);
            }
        }
        return closePorts;
    }

    public static List<Integer> getClosePorts(String host, int start, int end) {
        Valid.gt(start, 0, "start port must greater than 0", new Object[0]);
        Valid.lte(end, 65535, "end port must less than 65536", new Object[0]);
        Valid.gt(end, start, "end port must greater than start", new Object[0]);
        ArrayList<Integer> closePorts = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, i), timeout);
                Streams.close(socket);
                continue;
            }
            catch (IOException ex) {
                closePorts.add(i);
            }
        }
        return closePorts;
    }

    public static boolean isOpen(String host, int port) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            Streams.close(socket);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isClose(String host, int port) {
        return !Ports.isOpen(host, port);
    }

    public static int getTimeout() {
        return timeout;
    }

    public static void setTimeout(int timeout) {
        Ports.timeout = timeout;
    }
}

