/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.math;

import com.orion.lang.utils.Strings;

public class Hex {
    private Hex() {
    }

    public static String byteToHex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String bytesToHex(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bs) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte hexToByte(String s) {
        return (byte)Integer.parseInt(s, 16);
    }

    public static byte[] hexToBytes(String s) {
        byte[] result;
        int len = s.length();
        if (len % 2 == 1) {
            result = new byte[++len / 2];
            s = "0" + s;
        } else {
            result = new byte[len / 2];
        }
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            result[j] = Hex.hexToByte(s.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static String encode(String s) {
        return Hex.bytesToHex(Strings.bytes(s));
    }

    public static String decode(String s) {
        return new String(Hex.hexToBytes(s));
    }
}

