/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.math;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Compares;
import com.orion.lang.utils.Objects1;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class BigDecimals {
    private BigDecimals() {
    }

    public static String format(Object o, String format) {
        try {
            DecimalFormat df = new DecimalFormat(format);
            return df.format(BigDecimals.objectToDecimal(o));
        }
        catch (Exception e) {
            return String.valueOf(o);
        }
    }

    public static BigDecimal toBigDecimal(Object o) {
        return BigDecimals.objectToDecimal(o);
    }

    public static BigDecimal toBigDecimal(Object o, BigDecimal defaultV) {
        return Objects1.def(BigDecimals.objectToDecimal(o), defaultV);
    }

    public static BigDecimal[] toBigDecimals(Object ... o) {
        int length = Arrays1.length(o);
        if (length == 0) {
            return new BigDecimal[0];
        }
        BigDecimal[] r = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            r[i] = BigDecimals.objectToDecimal(o[i]);
        }
        return r;
    }

    private static BigDecimal objectToDecimal(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof String) {
            return new BigDecimal((String)o);
        }
        if (o instanceof Byte) {
            return new BigDecimal(((Byte)o).byteValue());
        }
        if (o instanceof Short) {
            return new BigDecimal(((Short)o).shortValue());
        }
        if (o instanceof Integer) {
            return new BigDecimal((Integer)o);
        }
        if (o instanceof Long) {
            return BigDecimal.valueOf((Long)o);
        }
        if (o instanceof Float) {
            return BigDecimal.valueOf(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o);
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        }
        if (o instanceof Character) {
            return new BigDecimal(o.toString());
        }
        if (o instanceof char[]) {
            return new BigDecimal((char[])o);
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        return null;
    }

    public static String toStr(BigDecimal b) {
        return BigDecimals.toStr(b, null, 2, RoundingMode.DOWN);
    }

    public static String toStr(BigDecimal b, String defaultV) {
        return BigDecimals.toStr(b, defaultV, 2, RoundingMode.DOWN);
    }

    public static String toStr(BigDecimal b, String defaultV, int length) {
        return BigDecimals.toStr(b, defaultV, length, RoundingMode.DOWN);
    }

    public static String toStr(BigDecimal b, String defaultV, int length, RoundingMode mode) {
        if (b == null) {
            return defaultV;
        }
        if (mode == null) {
            return b.setScale(length).toPlainString();
        }
        return b.setScale(length, mode).toPlainString();
    }

    public static Long toLong(BigDecimal b) {
        return BigDecimals.toLong(b, 0L);
    }

    public static Long toLong(BigDecimal b, Long defaultV) {
        if (b == null) {
            return defaultV;
        }
        return b.longValue();
    }

    public static Integer toInteger(BigDecimal b) {
        return BigDecimals.toInteger(b, 0);
    }

    public static Integer toInteger(BigDecimal b, Integer defaultV) {
        if (b == null) {
            return defaultV;
        }
        return b.intValue();
    }

    public static Double toDouble(BigDecimal b) {
        return BigDecimals.toDouble(b, 0.0, 2, RoundingMode.DOWN);
    }

    public static Double toDouble(BigDecimal b, Double defaultV) {
        return BigDecimals.toDouble(b, defaultV, 2, RoundingMode.DOWN);
    }

    public static Double toDouble(BigDecimal b, Double defaultV, int length) {
        return BigDecimals.toDouble(b, defaultV, length, RoundingMode.DOWN);
    }

    public static Double toDouble(BigDecimal b, Double defaultV, int length, RoundingMode mode) {
        if (b == null) {
            return defaultV;
        }
        if (mode == null) {
            return b.setScale(length).doubleValue();
        }
        return b.setScale(length, mode).doubleValue();
    }

    public static BigDecimal add(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.add(false, s, b);
    }

    public static BigDecimal addSkipNegative(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.add(true, s, b);
    }

    private static BigDecimal add(boolean skipNegative, BigDecimal s, BigDecimal ... b) {
        if (s == null) {
            s = BigDecimal.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigDecimal c : b) {
            if (c == null) continue;
            if (skipNegative) {
                if (c.compareTo(BigDecimal.ZERO) <= 0) continue;
                s = s.add(c);
                continue;
            }
            s = s.add(c);
        }
        return s;
    }

    public static BigDecimal subtract(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.subtract(false, s, b);
    }

    public static BigDecimal subtractSkipNegative(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.subtract(true, s, b);
    }

    private static BigDecimal subtract(boolean skipNegative, BigDecimal s, BigDecimal ... b) {
        if (s == null) {
            s = BigDecimal.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigDecimal c : b) {
            if (c == null) continue;
            if (skipNegative) {
                if (c.compareTo(BigDecimal.ZERO) <= 0) continue;
                s = s.subtract(c);
                continue;
            }
            s = s.subtract(c);
        }
        return s;
    }

    public static BigDecimal multiply(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.multiply(false, false, s, b);
    }

    public static BigDecimal multiplySkip(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.multiply(true, true, s, b);
    }

    public static BigDecimal multiplySkipNegative(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.multiply(true, false, s, b);
    }

    public static BigDecimal multiplySkipZero(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.multiply(false, true, s, b);
    }

    private static BigDecimal multiply(boolean skipNegative, boolean skipZero, BigDecimal s, BigDecimal ... b) {
        if (s == null) {
            s = BigDecimal.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigDecimal c : b) {
            if (c == null) continue;
            if (skipNegative || skipZero) {
                int compare = c.compareTo(BigDecimal.ZERO);
                if (compare > 0) {
                    s = s.multiply(c);
                    continue;
                }
                if (compare == 0) {
                    if (skipZero) continue;
                    s = s.multiply(c);
                    continue;
                }
                if (skipNegative) continue;
                s = s.multiply(c);
                continue;
            }
            s = s.multiply(c);
        }
        return s;
    }

    public static BigDecimal divide(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.divide(false, false, s, b);
    }

    public static BigDecimal divideSkip(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.divide(true, true, s, b);
    }

    public static BigDecimal divideSkipNegative(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.divide(true, false, s, b);
    }

    public static BigDecimal divideSkipZero(BigDecimal s, BigDecimal ... b) {
        return BigDecimals.divide(false, true, s, b);
    }

    private static BigDecimal divide(boolean skipNegative, boolean skipZero, BigDecimal s, BigDecimal ... b) {
        if (s == null) {
            return BigDecimal.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigDecimal c : b) {
            if (c == null) continue;
            if (skipNegative || skipZero) {
                int compare = c.compareTo(BigDecimal.ZERO);
                if (compare > 0) {
                    s = s.divide(c);
                    continue;
                }
                if (compare == 0) {
                    if (skipZero) continue;
                    s = s.divide(c);
                    continue;
                }
                if (skipNegative) continue;
                s = s.divide(c);
                continue;
            }
            s = s.divide(c);
        }
        return s;
    }

    public static BigDecimal max(BigDecimal ... b) {
        int len = Arrays1.length(b);
        if (len == 0) {
            return null;
        }
        BigDecimal max = b[0];
        if (max == null) {
            for (int offset = 1; offset < len; ++offset) {
                BigDecimal bi = b[offset];
                if (bi == null) continue;
                max = bi;
                ++offset;
                break;
            }
            if (max == null) {
                return null;
            }
        }
        for (int i = offset; i < len; ++i) {
            if (b[i] == null || max.compareTo(b[i]) >= 0) continue;
            max = b[i];
        }
        return max;
    }

    public static BigDecimal min(BigDecimal ... b) {
        int len = Arrays1.length(b);
        if (len == 0) {
            return null;
        }
        BigDecimal min = b[0];
        if (min == null) {
            for (int offset = 1; offset < len; ++offset) {
                BigDecimal bi = b[offset];
                if (bi == null) continue;
                min = bi;
                ++offset;
                break;
            }
            if (min == null) {
                return null;
            }
        }
        for (int i = offset; i < len; ++i) {
            if (b[i] == null || min.compareTo(b[i]) <= 0) continue;
            min = b[i];
        }
        return min;
    }

    public static BigDecimal sum(BigDecimal ... b) {
        return BigDecimals.sum(false, b);
    }

    public static BigDecimal sumSkipNegative(BigDecimal ... b) {
        return BigDecimals.sum(true, b);
    }

    private static BigDecimal sum(boolean skipNegative, BigDecimal ... b) {
        BigDecimal sum = BigDecimal.ZERO;
        int len = Arrays1.length(b);
        for (int i = 0; i < len; ++i) {
            BigDecimal d = b[i];
            if (d.compareTo(BigDecimal.ZERO) < 0) {
                if (skipNegative) continue;
                sum = sum.add(d);
                continue;
            }
            sum = sum.add(d);
        }
        return sum;
    }

    public static BigDecimal avg(BigDecimal ... b) {
        return BigDecimals.avg(false, false, b);
    }

    public static BigDecimal avgSkipZero(BigDecimal ... b) {
        return BigDecimals.avg(true, false, b);
    }

    public static BigDecimal avgSkipNegative(BigDecimal ... b) {
        return BigDecimals.avg(false, true, b);
    }

    public static BigDecimal avgSkip(BigDecimal ... b) {
        return BigDecimals.avg(true, true, b);
    }

    private static BigDecimal avg(boolean skipZero, boolean skipNegative, BigDecimal ... b) {
        BigDecimal c;
        int len = Arrays1.length(b);
        int skip = 0;
        if (len == 0) {
            return null;
        }
        if (skipZero && skipNegative) {
            for (BigDecimal d : b) {
                if (d.compareTo(BigDecimal.ZERO) > 0) continue;
                ++skip;
            }
        } else if (skipZero) {
            for (BigDecimal d : b) {
                if (d.compareTo(BigDecimal.ZERO) != 0) continue;
                ++skip;
            }
        } else if (skipNegative) {
            for (BigDecimal d : b) {
                if (d.compareTo(BigDecimal.ZERO) >= 0) continue;
                ++skip;
            }
        }
        if ((c = skipNegative ? BigDecimals.add(true, null, b) : BigDecimals.add(false, null, b)).equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return c.divide(new BigDecimal(len - skip), 10, RoundingMode.DOWN);
    }

    public static boolean eq(BigDecimal d1, BigDecimal d2) {
        return Objects1.eq(d1, d2);
    }

    public static boolean compared(BigDecimal d1, BigDecimal d2) {
        return Compares.compared(d1, d2);
    }

    public static boolean isDecimal(BigDecimal d) {
        return Double.compare(d.doubleValue(), d.longValue()) != 0;
    }

    public static boolean isNegative(BigDecimal d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigDecimal.ZERO) < 0;
    }

    public static BigDecimal abs(BigDecimal d) {
        if (d == null) {
            return null;
        }
        return d.abs();
    }

    public static boolean isZero(BigDecimal d) {
        if (d == null) {
            return false;
        }
        return BigDecimal.ZERO.equals(d);
    }

    public static boolean ltZero(BigDecimal d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean lteZero(BigDecimal d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean gtZero(BigDecimal d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean gteZero(BigDecimal d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static BigDecimal parse(String value, String format) {
        return BigDecimals.parse(value, format, null);
    }

    public static BigDecimal parse(String value, String format, BigDecimal defaultV) {
        if (value == null) {
            return defaultV;
        }
        try {
            return BigDecimals.objectToDecimal(new DecimalFormat(format).parse(value));
        }
        catch (Exception e) {
            return defaultV;
        }
    }
}

