/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.orion.lang.utils.Strings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Jsons {
    private Jsons() {
    }

    public static String toJson(Object bean) {
        if (bean == null) {
            return "";
        }
        return JSON.toJSONString((Object)bean);
    }

    public static String toJsonLog(Object bean) {
        if (bean == null) {
            return "";
        }
        return JSON.toJSONString((Object)bean, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
    }

    public static String toJsonWriteNull(Object bean) {
        if (bean == null) {
            return "";
        }
        return JSON.toJSONString((Object)bean, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public static String toJson(Object bean, SerializerFeature ... features) {
        if (bean == null) {
            return "";
        }
        if (features == null) {
            return JSON.toJSONString((Object)bean);
        }
        return JSON.toJSONString((Object)bean, (SerializerFeature[])features);
    }

    public static <T> T toBean(String json, Class<T> targetClass) {
        if (Strings.isBlank(json)) {
            return null;
        }
        return (T)JSON.parseObject((String)json, targetClass);
    }

    public static <T> T toBean(String json, Class<T> targetClass, Feature ... features) {
        if (Strings.isBlank(json)) {
            return null;
        }
        return (T)JSON.parseObject((String)json, targetClass, (Feature[])features);
    }

    public static <T> List<T> toList(String json, Class<T> targetClass) {
        if (Strings.isBlank(json)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)json, targetClass);
    }

    public static <T> Set<T> toSet(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return new HashSet(16);
        }
        return (Set)JSON.parseObject((String)json, (TypeReference)new TypeReference<Set<T>>(new Type[]{clazz}){}, (Feature[])new Feature[0]);
    }

    public static Map<String, Object> toMap(String json) {
        if (Strings.isBlank(json)) {
            return new HashMap<String, Object>(16);
        }
        return JSON.parseObject((String)json).getInnerMap();
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> kc, Class<V> vc) {
        if (Strings.isBlank(json)) {
            return new HashMap(16);
        }
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<K, V>>(new Type[]{kc, vc}){}, (Feature[])new Feature[0]);
    }

    public static JSONObject toJsonObject(String json) {
        if (Strings.isBlank(json)) {
            return new JSONObject();
        }
        return JSON.parseObject((String)json);
    }

    public static <T> T toJsonObject(String json, TypeReference<T> ref) {
        return (T)JSON.parseObject((String)json, ref, (Feature[])new Feature[0]);
    }

    public static JSONArray toJsonArray(String json) {
        if (Strings.isBlank(json)) {
            return new JSONArray();
        }
        return JSON.parseArray((String)json);
    }

    public static String createJsonp(String function, Object ... params) {
        JSONPObject call = new JSONPObject();
        call.setFunction(function);
        if (params != null) {
            for (Object param : params) {
                call.addParameter(param);
            }
        }
        return call.toString();
    }

    public static String encode(String json) {
        if (Strings.isBlank(json)) {
            return "";
        }
        if (Strings.isBlank(json = JSON.toJSONString((Object)json))) {
            return "";
        }
        return json.substring(1, json.length() - 1);
    }

    public static String decode(String json) {
        if (Strings.isBlank(json)) {
            return "";
        }
        return json.replaceAll("\\\\", "");
    }

    public static String compress(String json) {
        if (Strings.isBlank(json)) {
            return "";
        }
        return json.replaceAll("\n", "").replaceAll("\r", "");
    }
}

