/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress.zip;

import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.io.compress.BaseFileDecompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipDecompressor
extends BaseFileDecompressor {
    private ZipFile zipFile;

    public ZipDecompressor() {
        this("zip");
    }

    public ZipDecompressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDecompress() throws Exception {
        try {
            this.zipFile = new ZipFile(this.decompressFile);
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(this.decompressTargetPath, entry.getName());
                if (entry.isDirectory()) {
                    Files1.mkdirs(file);
                    continue;
                }
                InputStream in = this.zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    OutputStream out = Files1.openOutputStreamFast(file);
                    Throwable throwable2 = null;
                    try {
                        Streams.transfer(in, out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        finally {
            Streams.close(this.zipFile);
        }
    }

    @Override
    public ZipFile getCloseable() {
        return this.zipFile;
    }
}

