/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress.z7;

import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.io.compress.BaseFileDecompressor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public class Z7Decompressor
extends BaseFileDecompressor {
    private SevenZFile z7File;

    public Z7Decompressor() {
        this("7z");
    }

    public Z7Decompressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDecompress() throws Exception {
        try {
            SevenZArchiveEntry entry;
            this.z7File = new SevenZFile(this.decompressFile);
            while ((entry = this.z7File.getNextEntry()) != null) {
                File file = new File(this.decompressTargetPath, entry.getName());
                if (entry.isDirectory()) {
                    Files1.mkdirs(file);
                    continue;
                }
                OutputStream out = Files1.openOutputStreamFast(file);
                Throwable throwable = null;
                try {
                    Z7Decompressor.transfer(this.z7File, out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        finally {
            Streams.close((AutoCloseable)this.z7File);
        }
    }

    public static void transfer(SevenZFile archive, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = archive.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
    }

    public SevenZFile getCloseable() {
        return this.z7File;
    }
}

