/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress.jar;

import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.io.compress.BaseFileCompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.zip.ZipOutputStream;

public class JarCompressor
extends BaseFileCompressor {
    private ZipOutputStream outputStream;

    public JarCompressor() {
        this("jar");
    }

    public JarCompressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCompress() throws Exception {
        try {
            this.outputStream = new ZipOutputStream(new BufferedOutputStream(Files1.openOutputStreamFast(this.getAbsoluteCompressPath())));
            for (Map.Entry fileEntity : this.compressFiles.entrySet()) {
                InputStream in = Files1.openInputStreamFast((File)fileEntity.getValue());
                Throwable throwable = null;
                try {
                    this.outputStream.putNextEntry(new JarEntry((String)fileEntity.getKey()));
                    Streams.transfer(in, (OutputStream)this.outputStream);
                    this.outputStream.closeEntry();
                    super.notify((String)fileEntity.getKey());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            for (Map.Entry fileEntity : this.compressStreams.entrySet()) {
                this.outputStream.putNextEntry(new JarEntry((String)fileEntity.getKey()));
                Streams.transfer((InputStream)fileEntity.getValue(), (OutputStream)this.outputStream);
                this.outputStream.closeEntry();
                super.notify((String)fileEntity.getKey());
            }
            this.outputStream.flush();
        }
        finally {
            Streams.close(this.outputStream);
        }
    }

    @Override
    public ZipOutputStream getCloseable() {
        return this.outputStream;
    }
}

