/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress.gz;

import com.orion.lang.id.ObjectIds;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.io.compress.BaseFileDecompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public class GzDecompressor
extends BaseFileDecompressor {
    private GzipCompressorInputStream inputStream;
    private InputStream decompressInputStream;
    private OutputStream decompressTargetOutputStream;
    private String decompressTargetFileName;
    private File decompressTargetFile;

    public GzDecompressor() {
        this("gz");
    }

    public GzDecompressor(String suffix) {
        super(suffix);
    }

    public void setDecompressInputStream(InputStream decompressInputStream) {
        this.decompressInputStream = decompressInputStream;
    }

    public void setDecompressTargetOutputStream(OutputStream decompressTargetOutputStream) {
        this.decompressTargetOutputStream = decompressTargetOutputStream;
    }

    public void setDecompressTargetFileName(String decompressTargetFileName) {
        this.decompressTargetFileName = decompressTargetFileName;
    }

    @Override
    public void decompress() throws Exception {
        if (this.decompressFile != null) {
            Valid.isTrue(Files1.isFile(this.decompressFile), "decompress file is not a file", new Object[0]);
        } else {
            Valid.notNull(this.decompressInputStream, "decompress file and decompress input stream is null", new Object[0]);
        }
        if (this.decompressTargetPath == null) {
            Valid.notNull(this.decompressTargetOutputStream, "decompress target path and is decompress target output stream null", new Object[0]);
        }
        this.doDecompress();
    }

    @Override
    public void doDecompress() throws Exception {
        OutputStream out = null;
        try {
            this.inputStream = this.decompressInputStream != null ? new GzipCompressorInputStream(this.decompressInputStream) : new GzipCompressorInputStream(Files1.openInputStreamFast(this.decompressFile));
            String entityName = Optional.ofNullable(this.inputStream.getMetaData()).map(GzipParameters::getFilename).orElse(null);
            if (this.decompressTargetFileName == null) {
                this.decompressTargetFileName = Objects1.def(entityName, Optional.ofNullable(this.decompressFile).map(File::getName).map(s -> s.substring(0, s.length() - this.suffix.length() - 1)).orElseGet(ObjectIds::nextId));
            }
            if (this.decompressTargetOutputStream != null) {
                out = this.decompressTargetOutputStream;
            } else {
                this.decompressTargetFile = new File(this.decompressTargetPath, this.decompressTargetFileName);
                out = Files1.openOutputStream(this.decompressTargetFile);
            }
            Streams.transfer((InputStream)this.inputStream, out);
        }
        catch (Throwable throwable) {
            Streams.close((AutoCloseable)this.inputStream);
            if (this.decompressTargetOutputStream == null) {
                Streams.close(out);
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)this.inputStream);
        if (this.decompressTargetOutputStream == null) {
            Streams.close(out);
        }
    }

    public File getDecompressTargetFile() {
        return this.decompressTargetFile;
    }

    public String getDecompressTargetFileName() {
        return this.decompressTargetFileName;
    }

    public GzipCompressorInputStream getCloseable() {
        return this.inputStream;
    }
}

