/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io;

public enum FileType {
    REGULAR_FILE("-", "\u666e\u901a\u6587\u4ef6"),
    DIRECTORY("d", "\u76ee\u5f55"),
    SYMLINK("l", "\u94fe\u63a5\u6587\u4ef6"),
    MANAGE_FILE("p", "\u7ba1\u7406\u6587\u4ef6"),
    BLOCK_DEVICE_FILE("b", "\u5757\u8bbe\u5907\u6587\u4ef6"),
    CHARACTER_DEVICE_FILE("c", "\u5b57\u7b26\u8bbe\u5907\u6587\u4ef6"),
    SOCKET_FILE("s", "\u5957\u63a5\u5b57\u6587\u4ef6");

    private final String symbol;
    private final String typeName;

    private FileType(String symbol, String typeName) {
        this.symbol = symbol;
        this.typeName = typeName;
    }

    public boolean isMatch(String entity) {
        if (entity == null) {
            return false;
        }
        return entity.startsWith(this.symbol);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static FileType of(String entity) {
        if (entity == null) {
            return null;
        }
        for (FileType value : FileType.values()) {
            if (!entity.startsWith(value.symbol)) continue;
            return value;
        }
        return null;
    }
}

