/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io;

import com.orion.lang.define.iterator.ByteArrayIterator;
import com.orion.lang.define.iterator.LineIterator;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.StreamReaders;
import com.orion.lang.utils.io.Streams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;

public class FileReaders {
    private static final String UTF_8 = "UTF-8";
    private static final Charset C_UTF_8 = StandardCharsets.UTF_8;

    private FileReaders() {
    }

    public static byte[] read(RandomAccessFile reader, long offset) throws IOException {
        return FileReaders.read(reader, offset, reader.length());
    }

    public static byte[] read(RandomAccessFile reader, long offset, long end) throws IOException {
        reader.seek(offset);
        long e = end;
        long len = reader.length();
        if (end > len) {
            e = len;
        }
        byte[] bs = new byte[(int)(end - offset)];
        reader.read(bs, 0, (int)(e - offset));
        return bs;
    }

    public static String readLine(RandomAccessFile reader) throws IOException {
        return FileReaders.readLine(reader, UTF_8);
    }

    public static String readLine(RandomAccessFile reader, String charset) throws IOException {
        int read;
        long pos = reader.getFilePointer();
        byte[] bytes = new byte[8192];
        byte[] line = new byte[8192];
        int linePos = 0;
        int seek = 0;
        while ((read = reader.read(bytes)) != -1) {
            seek += read;
            int bi = -1;
            for (int i = 0; i < read; ++i) {
                byte b = bytes[i];
                if (b == 13) {
                    if (i + 1 < read) {
                        if (bytes[i + 1] == 10) {
                            ++seek;
                        }
                        bi = i;
                        break;
                    }
                    byte[] bs1 = new byte[1];
                    int tmpRead = reader.read(bs1);
                    if (tmpRead != -1 && bs1[0] == 10) {
                        ++seek;
                    }
                    bi = i;
                    break;
                }
                if (b != 10) continue;
                bi = i;
                break;
            }
            if (bi != -1) {
                line = Arrays1.arraycopy(bytes, 0, line, linePos, bi);
                linePos += bi;
                seek -= read - bi - 1;
                break;
            }
            line = Arrays1.arraycopy(bytes, 0, line, linePos, read);
            linePos += read;
        }
        reader.seek(pos + (long)seek);
        if (seek == 0 || linePos == 0) {
            return "";
        }
        return new String(line, 0, linePos, charset);
    }

    public static String readAllLines(RandomAccessFile reader) throws IOException {
        return FileReaders.readAllLines(reader, UTF_8);
    }

    public static String readAllLines(RandomAccessFile reader, String charset) throws IOException {
        long pos = reader.getFilePointer();
        long length = reader.length();
        int more = (int)(length - pos);
        if (more <= 0) {
            return "";
        }
        byte[] buffer = new byte[more];
        int read = reader.read(buffer);
        return new String(buffer, 0, read, charset);
    }

    public static long readTailLinesSeek(RandomAccessFile reader, int line) throws IOException {
        long beforePos = reader.getFilePointer();
        long len = reader.length();
        if (len == 0L || line == 0) {
            return 0L;
        }
        boolean lastLf = false;
        long pos = len;
        while (pos > 0L) {
            boolean isLf;
            reader.seek(--pos);
            int read = reader.read();
            boolean bl = isLf = read == 10;
            if (!isLf && (lastLf || read != 13)) continue;
            if (isLf) {
                lastLf = true;
            }
            if (pos != len - 1L) {
                --line;
            }
            if (line > 0) continue;
            ++pos;
            break;
        }
        reader.seek(beforePos);
        return pos;
    }

    public static String readTailLines(RandomAccessFile reader, int line) throws IOException {
        return FileReaders.readTailLines(reader, UTF_8, line);
    }

    public static String readTailLines(RandomAccessFile reader, String charset, int line) throws IOException {
        long seek = FileReaders.readTailLinesSeek(reader, line);
        byte[] read = FileReaders.read(reader, seek);
        return new String(read, charset);
    }

    public static int read(String file, byte[] bytes) {
        return FileReaders.read(new File(file), bytes, 0L);
    }

    public static int read(File file, byte[] bytes) {
        return FileReaders.read(file, bytes, 0L);
    }

    public static int read(String file, byte[] bytes, long skip) {
        return FileReaders.read(new File(file), bytes, skip);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int read(File file, byte[] bytes, long skip) {
        try (FileInputStream in = Files1.openInputStream(file);){
            int n = StreamReaders.read(in, bytes, skip);
            return n;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static byte[] readAllBytes(String file) {
        return FileReaders.readAllBytes(new File(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readAllBytes(File file) {
        try (FileInputStream in = Files1.openInputStream(file);){
            byte[] byArray = StreamReaders.readAllBytes(in);
            return byArray;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static String readLine(String file) {
        return FileReaders.readLine(new File(file), 0L, UTF_8);
    }

    public static String readLine(File file) {
        return FileReaders.readLine(file, 0L, UTF_8);
    }

    public static String readLine(String file, String charset) {
        return FileReaders.readLine(new File(file), 0L, charset);
    }

    public static String readLine(File file, String charset) {
        return FileReaders.readLine(file, 0L, charset);
    }

    public static String readLine(String file, long skip) {
        return FileReaders.readLine(new File(file), skip, UTF_8);
    }

    public static String readLine(File file, long skip) {
        return FileReaders.readLine(file, skip, UTF_8);
    }

    public static String readLine(String file, long skip, String charset) {
        return FileReaders.readLine(new File(file), skip, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLine(File file, long skip, String charset) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)Files1.openInputStream(file), Strings.def(charset, UTF_8)));){
            String string = StreamReaders.readLine((Reader)reader, skip);
            return string;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static String readLine(String file, int skipLine) {
        return FileReaders.readLine(new File(file), (long)skipLine, UTF_8);
    }

    public static String readLine(File file, int skipLine) {
        return FileReaders.readLine(file, (long)skipLine, UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLine(String file, int skipLine, String charset) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)Files1.openInputStream(file), Strings.def(charset, UTF_8)));){
            String string = StreamReaders.readLine((Reader)reader, skipLine);
            return string;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static List<String> readLines(File file) {
        return FileReaders.readLines(file, 0L, -1, UTF_8);
    }

    public static List<String> readLines(String file) {
        return FileReaders.readLines(new File(file), 0L, -1, UTF_8);
    }

    public static List<String> readLines(File file, int lines) {
        return FileReaders.readLines(file, 0L, lines, UTF_8);
    }

    public static List<String> readLines(String file, int lines) {
        return FileReaders.readLines(new File(file), 0L, lines, UTF_8);
    }

    public static List<String> readLines(String file, int lines, String charset) {
        return FileReaders.readLines(new File(file), 0L, lines, charset);
    }

    public static List<String> readLines(File file, int lines, String charset) {
        return FileReaders.readLines(file, 0L, lines, charset);
    }

    public static List<String> readLines(File file, long skip) {
        return FileReaders.readLines(file, skip, -1, UTF_8);
    }

    public static List<String> readLines(String file, long skip) {
        return FileReaders.readLines(new File(file), skip, -1, UTF_8);
    }

    public static List<String> readLines(File file, long skip, int lines) {
        return FileReaders.readLines(file, skip, lines, UTF_8);
    }

    public static List<String> readLines(String file, long skip, int lines) {
        return FileReaders.readLines(new File(file), skip, lines, UTF_8);
    }

    public static List<String> readLines(String file, long skip, int lines, String charset) {
        return FileReaders.readLines(new File(file), skip, lines, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(File file, long skip, int lines, String charset) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)Files1.openInputStream(file), Strings.def(charset, UTF_8)));){
            List<String> list = StreamReaders.readLines((Reader)reader, skip, lines);
            return list;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static List<String> readLines(File file, int skipLine, int lines) {
        return FileReaders.readLines(file, skipLine, lines, UTF_8);
    }

    public static List<String> readLines(String file, int skipLine, int lines) {
        return FileReaders.readLines(new File(file), skipLine, lines, UTF_8);
    }

    public static List<String> readLines(String file, int skipLine, int lines, String charset) {
        return FileReaders.readLines(new File(file), skipLine, lines, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(File file, int skipLine, int lines, String charset) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)Files1.openInputStream(file), Strings.def(charset, UTF_8)));){
            List<String> list = StreamReaders.readLines((Reader)reader, skipLine, lines);
            return list;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void lineConsumer(String file, Consumer<String> c) {
        FileReaders.lineConsumer(new File(file), UTF_8, c);
    }

    public static void lineConsumer(File file, Consumer<String> c) {
        FileReaders.lineConsumer(file, UTF_8, c);
    }

    public static void lineConsumer(String file, String charset, Consumer<String> c) {
        FileReaders.lineConsumer(new File(file), charset, c);
    }

    public static void lineConsumer(File file, String charset, Consumer<String> c) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)Files1.openInputStream(file), Strings.def(charset, UTF_8)));){
            Streams.lineConsumer(reader, c);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static LineIterator lineIterator(String file) {
        return FileReaders.lineIterator(new File(file), UTF_8);
    }

    public static LineIterator lineIterator(File file) {
        return FileReaders.lineIterator(file, UTF_8);
    }

    public static LineIterator lineIterator(String file, String charset) {
        return FileReaders.lineIterator(new File(file), charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LineIterator lineIterator(File file, String charset) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)Files1.openInputStream(file), Strings.def(charset, UTF_8)));){
            LineIterator lineIterator = Streams.lineIterator(reader).autoClose(true);
            return lineIterator;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void byteArrayConsumer(String file, byte[] bytes, IntConsumer c) {
        FileReaders.byteArrayConsumer(new File(file), bytes, c);
    }

    public static void byteArrayConsumer(File file, byte[] bytes, IntConsumer c) {
        try (FileInputStream in = Files1.openInputStream(file);){
            Streams.byteArrayConsumer(in, bytes, c);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static ByteArrayIterator byteArrayIterator(String file, byte[] buffer) {
        return FileReaders.byteArrayIterator(new File(file), buffer);
    }

    public static ByteArrayIterator byteArrayIterator(File file, byte[] buffer) {
        try {
            return Streams.byteArrayIterator(Files1.openInputStream(file), buffer).autoClose(true);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static byte[] readAllBytesFast(String file) {
        return FileReaders.readAllBytesFast(Paths.get(file, new String[0]));
    }

    public static byte[] readAllBytesFast(File file) {
        return FileReaders.readAllBytesFast(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static byte[] readAllBytesFast(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static List<String> readLinesFast(String file) {
        return FileReaders.readLinesFast(Paths.get(file, new String[0]), C_UTF_8);
    }

    public static List<String> readLinesFast(File file) {
        return FileReaders.readLinesFast(Paths.get(file.getAbsolutePath(), new String[0]), C_UTF_8);
    }

    public static List<String> readLinesFast(Path file) {
        return FileReaders.readLinesFast(file, C_UTF_8);
    }

    public static List<String> readLinesFast(String file, String charset) {
        return FileReaders.readLinesFast(Paths.get(file, new String[0]), Charset.forName(charset));
    }

    public static List<String> readLinesFast(File file, String charset) {
        return FileReaders.readLinesFast(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName(charset));
    }

    public static List<String> readLinesFast(Path file, Charset charset) {
        try {
            return Files.readAllLines(file, Objects1.def(charset, C_UTF_8));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void lineConsumerFast(String file, Consumer<String> c) {
        FileReaders.lineConsumerFast(Paths.get(file, new String[0]), C_UTF_8, c);
    }

    public static void lineConsumerFast(File file, Consumer<String> c) {
        FileReaders.lineConsumerFast(Paths.get(file.getAbsolutePath(), new String[0]), C_UTF_8, c);
    }

    public static void lineConsumerFast(Path file, Consumer<String> c) {
        FileReaders.lineConsumerFast(file, C_UTF_8, c);
    }

    public static void lineConsumerFast(String file, String charset, Consumer<String> c) {
        FileReaders.lineConsumerFast(Paths.get(file, new String[0]), Charset.forName(charset), c);
    }

    public static void lineConsumerFast(File file, String charset, Consumer<String> c) {
        FileReaders.lineConsumerFast(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName(charset), c);
    }

    public static void lineConsumerFast(Path file, Charset charset, Consumer<String> c) {
        try (Stream<String> stream = Files.lines(file, Objects1.def(charset, C_UTF_8));){
            stream.forEach(c);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static LineIterator lineIteratorFast(String file) {
        return FileReaders.lineIteratorFast(Paths.get(file, new String[0]), C_UTF_8);
    }

    public static LineIterator lineIteratorFast(File file) {
        return FileReaders.lineIteratorFast(Paths.get(file.getAbsolutePath(), new String[0]), C_UTF_8);
    }

    public static LineIterator lineIteratorFast(Path file) {
        return FileReaders.lineIteratorFast(file, C_UTF_8);
    }

    public static LineIterator lineIteratorFast(String file, String charset) {
        return FileReaders.lineIteratorFast(Paths.get(file, new String[0]), Charset.forName(charset));
    }

    public static LineIterator lineIteratorFast(File file, String charset) {
        return FileReaders.lineIteratorFast(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName(charset));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LineIterator lineIteratorFast(Path file, Charset charset) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files1.openInputStreamFast(file), Objects1.def(charset, C_UTF_8)));){
            LineIterator lineIterator = Streams.lineIterator(reader).autoClose(true);
            return lineIterator;
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void byteArrayConsumerFast(String file, byte[] bytes, IntConsumer c) {
        FileReaders.byteArrayConsumerFast(Paths.get(file, new String[0]), bytes, c);
    }

    public static void byteArrayConsumerFast(File file, byte[] bytes, IntConsumer c) {
        FileReaders.byteArrayConsumerFast(Paths.get(file.getAbsolutePath(), new String[0]), bytes, c);
    }

    public static void byteArrayConsumerFast(Path file, byte[] bytes, IntConsumer c) {
        try (InputStream in = Files1.openInputStreamFast(file);){
            Streams.byteArrayConsumer(in, bytes, c);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static ByteArrayIterator byteArrayIteratorFast(String file, byte[] buffer) {
        return FileReaders.byteArrayIteratorFast(Paths.get(file, new String[0]), buffer);
    }

    public static ByteArrayIterator byteArrayIteratorFast(File file, byte[] buffer) {
        return FileReaders.byteArrayIteratorFast(Paths.get(file.getAbsolutePath(), new String[0]), buffer);
    }

    public static ByteArrayIterator byteArrayIteratorFast(Path file, byte[] buffer) {
        try {
            return Streams.byteArrayIterator(Files1.openInputStreamFast(file), buffer).autoClose(true);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }
}

