/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io;

import com.orion.lang.utils.io.Files1;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public class FileAttribute
implements Serializable {
    private static final long serialVersionUID = 90456092839304098L;
    private final BasicFileAttributes attr;
    private Path path;
    private String fileName;
    private String filePath;
    private long size;
    private boolean symbolicLink;
    private boolean directory;
    private boolean regularFile;
    private boolean other;
    private long createTime;
    private long accessTime;
    private long modifiedTime;

    public FileAttribute(Path path, BasicFileAttributes attr) {
        this.path = path;
        this.attr = attr;
        this.filePath = path.toString();
        this.fileName = Files1.getFileName(this.filePath);
        this.size = attr.size();
        this.symbolicLink = attr.isSymbolicLink();
        this.directory = attr.isDirectory();
        this.regularFile = attr.isRegularFile();
        this.other = attr.isOther();
        this.createTime = attr.creationTime().toMillis();
        this.accessTime = attr.lastAccessTime().toMillis();
        this.modifiedTime = attr.lastModifiedTime().toMillis();
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public BasicFileAttributes getAttr() {
        return this.attr;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }

    public void setSymbolicLink(boolean symbolicLink) {
        this.symbolicLink = symbolicLink;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isRegularFile() {
        return this.regularFile;
    }

    public void setRegularFile(boolean regularFile) {
        this.regularFile = regularFile;
    }

    public boolean isOther() {
        return this.other;
    }

    public void setOther(boolean other) {
        this.other = other;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(long modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public File getFile() {
        return this.path.toFile();
    }

    public URI getUri() {
        return this.path.toUri();
    }

    public String toString() {
        return this.filePath;
    }
}

