/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.ext.dom;

import com.orion.lang.able.Buildable;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.collect.Lists;
import com.orion.lang.utils.collect.Maps;
import com.orion.lang.utils.ext.dom.DomElement;
import com.orion.lang.utils.ext.dom.DomSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultElement;

public class DomBuilder
implements Buildable<DomBuilder> {
    private DomElement domElement;
    private Document document;
    private String charset = "UTF-8";

    public static DomBuilder create() {
        return new DomBuilder();
    }

    public DomBuilder setDomElement(DomElement domElement) {
        this.domElement = domElement;
        return this;
    }

    public DomElement createRootElement(String name) {
        this.domElement = new DomElement(name);
        return this.domElement;
    }

    public DomBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public DomBuilder build() {
        Valid.notNull(this.domElement, "element is null", new Object[0]);
        this.document = new DefaultDocument();
        this.document.setXMLEncoding(this.charset);
        DefaultElement rootElement = new DefaultElement(this.domElement.getName());
        this.document.setRootElement((Element)rootElement);
        rootElement.setAttributes(this.getAttribute(this.domElement.getAttributes()));
        if (this.domElement.getValue() != null) {
            if (this.domElement.isCdata()) {
                rootElement.add((CDATA)new DefaultCDATA(this.domElement.getValue()));
            } else {
                rootElement.setText(this.domElement.getValue());
            }
        } else if (!Lists.isEmpty(this.domElement.getChildNode())) {
            for (DomElement info : this.domElement.getChildNode()) {
                this.buildChildElement((Element)rootElement, info);
            }
        }
        return this;
    }

    private void buildChildElement(Element element, DomElement domElement) {
        DefaultElement e = new DefaultElement(domElement.getName());
        element.add((Element)e);
        e.setAttributes(this.getAttribute(domElement.getAttributes()));
        if (domElement.getValue() != null) {
            if (domElement.isCdata()) {
                e.add((CDATA)new DefaultCDATA(domElement.getValue()));
            } else {
                e.setText(domElement.getValue());
            }
        } else if (!Lists.isEmpty(domElement.getChildNode())) {
            for (DomElement info : domElement.getChildNode()) {
                this.buildChildElement((Element)e, info);
            }
        }
    }

    private List<Attribute> getAttribute(Map<String, String> map) {
        if (Maps.isEmpty(map)) {
            return new ArrayList<Attribute>();
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            list.add((Attribute)new DefaultAttribute(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    public Document getDocument() {
        return this.document;
    }

    public DomElement getDomElement() {
        return this.domElement;
    }

    public Element getRootElement() {
        return this.document.getRootElement();
    }

    public String getXml() {
        return this.document.asXML();
    }

    public String getFormatXml() {
        return DomSupport.format(this.document);
    }

    public String getFormatXml(OutputFormat format) {
        return DomSupport.format(this.document, format);
    }

    public void write(File file) throws IOException {
        DomSupport.write(this.document.asXML(), file);
    }

    public String toString() {
        return this.document.asXML();
    }
}

