/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto.enums;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.crypto.enums.PaddingMode;
import com.orion.lang.utils.crypto.enums.WorkingMode;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public enum CipherAlgorithm {
    RSA("RSA"),
    AES("AES"),
    DES("DES"),
    DES3("DESEDE"),
    SM4("SM4"){

        @Override
        public Cipher getCipher(String work, String padding) {
            return super.getCipher(work, padding, "BC");
        }

        @Override
        public Cipher getCipher(WorkingMode work, PaddingMode padding) {
            return super.getCipher(work, padding, "BC");
        }
    };

    private final String mode;

    private CipherAlgorithm(String model) {
        this.mode = model;
    }

    public String getMode() {
        return this.mode;
    }

    public Cipher getCipher() {
        try {
            return Cipher.getInstance(this.mode);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public Cipher getCipher(String work, String padding) {
        try {
            return Cipher.getInstance(this.getCipherMode(work, padding));
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public Cipher getCipher(WorkingMode work, PaddingMode padding) {
        try {
            return Cipher.getInstance(this.getCipherMode(work, padding));
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public Cipher getCipher(String work, String padding, String provider) {
        try {
            return Cipher.getInstance(this.getCipherMode(work, padding), provider);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public Cipher getCipher(WorkingMode work, PaddingMode padding, String provider) {
        try {
            return Cipher.getInstance(this.getCipherMode(work, padding), provider);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public Cipher getCipher(String work, String padding, Provider provider) {
        try {
            return Cipher.getInstance(this.getCipherMode(work, padding), provider);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public Cipher getCipher(WorkingMode work, PaddingMode padding, Provider provider) {
        try {
            return Cipher.getInstance(this.getCipherMode(work, padding), provider);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    protected String getCipherMode(WorkingMode work, PaddingMode padding) {
        return this.getCipherMode(work.getMode(), padding.getMode());
    }

    protected String getCipherMode(String work, String padding) {
        return this.mode + "/" + work + "/" + padding;
    }

    public static Cipher getCipher(String model) {
        CipherAlgorithm[] values;
        if (Strings.isBlank(model)) {
            return null;
        }
        for (CipherAlgorithm value : values = CipherAlgorithm.values()) {
            if (!value.getMode().equalsIgnoreCase(model.trim())) continue;
            return value.getCipher();
        }
        return null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

