/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto;

import com.orion.lang.define.wrapper.Pair;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.codec.Base64s;
import com.orion.lang.utils.crypto.enums.CipherAlgorithm;
import com.orion.lang.utils.crypto.enums.SecretKeySpecMode;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Keys {
    private Keys() {
    }

    public static PublicKey getCerPublicKey(File file) {
        return Keys.getCerPublicKey(Files1.openInputStreamSafe(file), true);
    }

    public static PublicKey getCerPublicKey(String file) {
        return Keys.getCerPublicKey(Files1.openInputStreamSafe(file), true);
    }

    public static PublicKey getCerPublicKey(InputStream in) {
        return Keys.getCerPublicKey(in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey getCerPublicKey(InputStream in, boolean close) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
            PublicKey publicKey = cert.getPublicKey();
            return publicKey;
        }
        catch (Exception e) {
            PublicKey publicKey = null;
            return publicKey;
        }
        finally {
            if (close) {
                Streams.close(in);
            }
        }
    }

    public static Pair<PublicKey, PrivateKey> getPfxKeys(File file, String password) {
        return Keys.getPfxKeys(Files1.openInputStreamSafe(file), password, true);
    }

    public static Pair<PublicKey, PrivateKey> getPfxKeys(String file, String password) {
        return Keys.getPfxKeys(Files1.openInputStreamSafe(file), password, true);
    }

    public static Pair<PublicKey, PrivateKey> getPfxKeys(InputStream in, String password) {
        return Keys.getPfxKeys(in, password, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<PublicKey, PrivateKey> getPfxKeys(InputStream in, String password, boolean close) {
        try {
            char[] ps = password == null ? null : password.toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(in, ps);
            Enumeration<String> aliases = ks.aliases();
            String keyAlias = null;
            if (aliases.hasMoreElements()) {
                keyAlias = aliases.nextElement();
            }
            Certificate cert = ks.getCertificate(keyAlias);
            Pair<PublicKey, PrivateKey> pair = Pair.of(cert.getPublicKey(), (PrivateKey)ks.getKey(keyAlias, ps));
            return pair;
        }
        catch (Exception e) {
            Pair<PublicKey, PrivateKey> pair = null;
            return pair;
        }
        finally {
            if (close) {
                Streams.close(in);
            }
        }
    }

    public static KeyStore getKeyStore(File file, String password) {
        return Keys.getKeyStore(Files1.openInputStreamSafe(file), password);
    }

    public static KeyStore getKeyStore(InputStream in, String password) {
        char[] ps = password == null ? null : password.toCharArray();
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(in, ps);
            return ks;
        }
        catch (Exception e) {
            throw Exceptions.runtime("could not be loaded key");
        }
    }

    public static String getPublicKey(PublicKey key) {
        return new String(Base64s.encode(key.getEncoded()));
    }

    public static String getPrivateKey(PrivateKey key) {
        return new String(Base64s.encode(key.getEncoded()));
    }

    public static String getSecretKey(SecretKey key) {
        return new String(Base64s.encode(key.getEncoded()));
    }

    public static String getKey(File file) {
        return Keys.getKey(new InputStreamReader(Files1.openInputStreamSafe(file)), true);
    }

    public static String getKey(String file) {
        return Keys.getKey(new InputStreamReader(Files1.openInputStreamSafe(file)), true);
    }

    public static String getKey(InputStream in) {
        return Keys.getKey(new InputStreamReader(in), false);
    }

    public static String getKey(Reader reader) {
        return Keys.getKey(reader, false);
    }

    public static String getKey(Reader reader, boolean close) {
        StringBuilder key = new StringBuilder();
        int c = 0;
        BufferedReader r = new BufferedReader(reader);
        try {
            String s = r.readLine();
            while (s != null) {
                if (s.contains("--")) {
                    if (++c == 2) {
                        break;
                    }
                } else {
                    key.append(s);
                }
                s = r.readLine();
            }
            String string = key.toString().replaceAll("\n", "").replaceAll("\r", "");
            return string;
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
        finally {
            if (close) {
                Streams.close(reader);
            }
        }
    }

    public static int getKeySpecLength(CipherAlgorithm mode) {
        switch (mode) {
            case AES: {
                return 128;
            }
            case DES: {
                return 8;
            }
            case DES3: {
                return 24;
            }
            case SM4: {
                return 16;
            }
            case RSA: {
                return 1024;
            }
        }
        throw Exceptions.unsupported("unsupported get " + (Object)((Object)mode) + " key spec length");
    }

    public static int getIvSpecLength(CipherAlgorithm mode) {
        switch (mode) {
            case AES: {
                return 16;
            }
            case DES: {
                return 8;
            }
            case DES3: {
                return 8;
            }
            case SM4: {
                return 16;
            }
        }
        throw Exceptions.unsupported("unsupported get " + (Object)((Object)mode) + "iv spec length");
    }

    public static int getGcmSpecLength(CipherAlgorithm mode) {
        switch (mode) {
            case AES: {
                return 128;
            }
        }
        throw Exceptions.unsupported("unsupported get " + (Object)((Object)mode) + "gcm spec length");
    }

    public static IvParameterSpec getIvSpec(byte[] iv) {
        return new IvParameterSpec(iv);
    }

    public static IvParameterSpec getIvSpec(CipherAlgorithm mode, byte[] iv) {
        return Keys.getIvSpec(iv, Keys.getIvSpecLength(mode));
    }

    public static IvParameterSpec getIvSpec(byte[] iv, int ivSpecLen) {
        return new IvParameterSpec(Arrays1.resize(iv, ivSpecLen));
    }

    public static GCMParameterSpec getGcmSpec(byte[] gcm) {
        return new GCMParameterSpec(gcm.length, gcm);
    }

    public static GCMParameterSpec getGcmSpec(CipherAlgorithm mode, byte[] gcm) {
        return new GCMParameterSpec(Keys.getGcmSpecLength(mode), gcm);
    }

    public static GCMParameterSpec getGcmSpec(byte[] gcm, int gcmSpecLen) {
        return new GCMParameterSpec(gcmSpecLen, gcm);
    }

    public static SecretKey getSecretKey(byte[] key, CipherAlgorithm mode) {
        return new SecretKeySpec(Base64s.decode(key), mode.getMode());
    }

    public static SecretKey getSecretKey(String key, CipherAlgorithm mode) {
        return new SecretKeySpec(Base64s.decode(Strings.bytes(key)), mode.getMode());
    }

    public static SecretKey generatorKey(String key, CipherAlgorithm mode) {
        return Keys.generatorKey(Strings.bytes(key), Keys.getKeySpecLength(mode), mode);
    }

    public static SecretKey generatorKey(byte[] key, CipherAlgorithm mode) {
        return Keys.generatorKey(key, Keys.getKeySpecLength(mode), mode);
    }

    public static SecretKey generatorKey(String key, int keySize, CipherAlgorithm mode) {
        return Keys.generatorKey(Strings.bytes(key), keySize, mode);
    }

    public static SecretKey generatorKey(byte[] key, int keySize, CipherAlgorithm mode) {
        return Keys.generatorKey(key, keySize, mode, "SHA1PRNG", "SUN");
    }

    public static SecretKey generatorKey(byte[] key, int keySize, CipherAlgorithm mode, String algorithm, String provider) {
        try {
            switch (mode) {
                case AES: {
                    KeyGenerator keyGenerator = KeyGenerator.getInstance(mode.getMode());
                    SecureRandom random = SecureRandom.getInstance(algorithm, provider);
                    random.setSeed(key);
                    keyGenerator.init(keySize, random);
                    return SecretKeySpecMode.AES.getSecretKeySpec(keyGenerator.generateKey().getEncoded());
                }
                case DES: {
                    if (key.length != keySize) {
                        key = Arrays1.resize(key, keySize);
                    }
                    return SecretKeyFactory.getInstance(mode.getMode()).generateSecret(new DESKeySpec(key));
                }
                case DES3: {
                    if (key.length != keySize) {
                        key = Arrays1.resize(key, keySize);
                    }
                    return SecretKeyFactory.getInstance(mode.getMode()).generateSecret(new DESedeKeySpec(key));
                }
                case SM4: {
                    if (key.length != keySize) {
                        key = Arrays1.resize(key, keySize);
                    }
                    return SecretKeySpecMode.SM4.getSecretKeySpec(key);
                }
            }
            throw Exceptions.unsupported("unsupported generator " + (Object)((Object)mode) + " key");
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }
}

