/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.collect;

import com.orion.lang.define.collect.ConcurrentHashSet;
import com.orion.lang.define.collect.EmptySet;
import com.orion.lang.define.collect.MutableHashSet;
import com.orion.lang.define.collect.MutableTreeSet;
import com.orion.lang.define.collect.PartitionSet;
import com.orion.lang.define.collect.SingletonSet;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.collect.Collections;
import com.orion.lang.utils.random.Randoms;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;

public class Sets
extends Collections {
    private Sets() {
    }

    public static <E> Set<E> newSet() {
        return new HashSet();
    }

    public static <E> Set<E> newSet(int capacity) {
        return new HashSet(capacity);
    }

    public static <E> Set<E> newSet(Collection<? extends E> c) {
        if (c == null) {
            return new HashSet();
        }
        return new HashSet<E>(c);
    }

    public static <E> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(comparator);
    }

    public static <E> TreeSet<E> newTreeSet(SortedSet<E> s) {
        if (s == null) {
            return new TreeSet();
        }
        return new TreeSet<E>(s);
    }

    public static <E> TreeSet<E> newTreeSet(Collection<? extends E> c) {
        if (c == null) {
            return new TreeSet();
        }
        return new TreeSet<E>(c);
    }

    public static <E> MutableHashSet<E> newMutableSet() {
        return new MutableHashSet();
    }

    public static <E> MutableHashSet<E> newMutableSet(int capacity) {
        return new MutableHashSet(capacity);
    }

    public static <E> MutableHashSet<E> newMutableSet(Collection<? extends E> c) {
        if (c == null) {
            return new MutableHashSet();
        }
        return new MutableHashSet<E>(c);
    }

    public static <E> MutableTreeSet<E> newMutableTreeSet() {
        return new MutableTreeSet();
    }

    public static <E> MutableTreeSet<E> newMutableTreeSet(Comparator<? super E> comparator) {
        return new MutableTreeSet<E>(comparator);
    }

    public static <E> MutableTreeSet<E> newMutableTreeSet(SortedSet<E> s) {
        if (s == null) {
            return new MutableTreeSet();
        }
        return new MutableTreeSet<E>(s);
    }

    public static <E> MutableTreeSet<E> newMutableTreeSet(Collection<? extends E> c) {
        if (c == null) {
            return new MutableTreeSet();
        }
        return new MutableTreeSet<E>(c);
    }

    public static <E> Set<E> newSynchronizedSet() {
        return java.util.Collections.synchronizedSet(new HashSet());
    }

    public static <E> Set<E> newSynchronizedSet(Set<E> set) {
        if (set == null) {
            return java.util.Collections.synchronizedSet(new HashSet());
        }
        return java.util.Collections.synchronizedSet(set);
    }

    public static <E> SortedSet<E> newSynchronizedSortedSet() {
        return java.util.Collections.synchronizedSortedSet(new TreeSet());
    }

    public static <E> SortedSet<E> newSynchronizedSortedSet(SortedSet<E> set) {
        if (set == null) {
            return java.util.Collections.synchronizedSortedSet(new TreeSet());
        }
        return java.util.Collections.synchronizedSortedSet(set);
    }

    public static BitSet newBitSet() {
        return new BitSet();
    }

    public static BitSet newBitSet(int initialSize) {
        return new BitSet(initialSize);
    }

    public static <E> ConcurrentHashSet<E> newCurrentSet() {
        return new ConcurrentHashSet();
    }

    public static <E> ConcurrentHashSet<E> newCurrentSet(int capacity) {
        return new ConcurrentHashSet(capacity);
    }

    public static <E> ConcurrentHashSet<E> newCurrentSet(Collection<? extends E> c) {
        if (c == null) {
            return new ConcurrentHashSet();
        }
        return new ConcurrentHashSet<E>(c);
    }

    public static <E> ConcurrentHashSet<E> newCurrentSet(Map<? extends E, ?> m) {
        if (m == null) {
            return new ConcurrentHashSet();
        }
        return new ConcurrentHashSet<E>(m);
    }

    public static <E> Set<E> unmodified(Set<? extends E> c) {
        return java.util.Collections.unmodifiableSet(c);
    }

    public static <E> Set<E> unmodified(SortedSet<E> c) {
        return java.util.Collections.unmodifiableSortedSet(c);
    }

    public static <E> Set<E> singleton(E e) {
        return new SingletonSet<E>(e);
    }

    public static <E> Set<E> empty() {
        return EmptySet.EMPTY;
    }

    public static <E> Set<E> def(Set<E> set) {
        return set == null ? new HashSet() : set;
    }

    public static <E> Set<E> def(Set<E> set, Set<E> def) {
        return set == null ? def : set;
    }

    public static <E> Set<E> def(Set<E> set, Supplier<Set<E>> def) {
        return set == null ? def.get() : set;
    }

    @SafeVarargs
    public static <E> Set<E> of(E ... e) {
        return new HashSet<E>(Arrays.asList(e));
    }

    @SafeVarargs
    public static <E, V> Set<E> of(Function<V, E> f, V ... e) {
        Valid.notNull(f, "convert function is null", new Object[0]);
        HashSet<E> list = new HashSet<E>();
        int length = Arrays1.length(e);
        for (int i = 0; i < length; ++i) {
            list.add(f.apply(e[i]));
        }
        return list;
    }

    public static <E, V> Set<E> map(List<V> l, Function<V, E> f) {
        Valid.notNull(f, "convert function is null", new Object[0]);
        HashSet<E> set = new HashSet<E>();
        if (Sets.isEmpty(l)) {
            return set;
        }
        for (V v : l) {
            set.add(f.apply(v));
        }
        return set;
    }

    public static <E> Set<E> as(Iterator<E> iterator) {
        LinkedHashSet<E> list = new LinkedHashSet<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }

    public static <E> Set<E> as(Enumeration<E> iterator) {
        LinkedHashSet<E> list = new LinkedHashSet<E>();
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                list.add(iterator.nextElement());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <E> Set<E> merge(Set<E> set, Set<E> ... ms) {
        if (set == null) {
            set = new HashSet();
        }
        if (ms == null) {
            return set;
        }
        for (Set<E> m : ms) {
            if (m == null) continue;
            set.addAll(m);
        }
        return set;
    }

    public static <E> E get(Set<E> set, int i) {
        if (Sets.size(set) <= i) {
            return null;
        }
        int idx = 0;
        for (E e : set) {
            if (idx++ != i) continue;
            return e;
        }
        return null;
    }

    public static <E> E random(Set<E> set) {
        int size = Sets.size(set);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return set.iterator().next();
        }
        return Sets.get(set, Randoms.RANDOM.nextInt(size));
    }

    public static <E> void removeToSize(Set<E> set, int size) {
        int i;
        int oldSize = Sets.size(set);
        if (size >= oldSize) {
            return;
        }
        Iterator<E> iterator = set.iterator();
        int d = oldSize - size;
        for (i = 0; i < size; ++i) {
            iterator.next();
        }
        for (i = 0; i < d; ++i) {
            iterator.next();
            iterator.remove();
        }
    }

    public static <E> Set<Set<E>> partition(Set<E> set, int size) {
        return new PartitionSet<E>(set, size);
    }

    public static <E> Set<E> distinct(Collection<E> c, Function<E, ?> keyGetter) {
        return new HashSet<E>(Collections.distinct(c, keyGetter));
    }
}

