/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.awt;

import com.orion.lang.utils.awt.Images;
import com.orion.lang.utils.io.Streams;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.resizers.configurations.AlphaInterpolation;
import net.coobird.thumbnailator.resizers.configurations.Antialiasing;
import net.coobird.thumbnailator.resizers.configurations.Dithering;
import net.coobird.thumbnailator.resizers.configurations.Rendering;
import net.coobird.thumbnailator.resizers.configurations.ScalingMode;

public class ImageExecutorStream {
    private String format;
    private final Thumbnails.Builder<?> builder;

    public ImageExecutorStream(String name) {
        this.builder = Thumbnails.of((File[])new File[]{new File(name)});
    }

    public ImageExecutorStream(File file) {
        this.builder = Thumbnails.of((File[])new File[]{file});
    }

    public ImageExecutorStream(InputStream in) {
        this.builder = Thumbnails.of((InputStream[])new InputStream[]{in});
    }

    public ImageExecutorStream(byte[] bs) {
        this.builder = Thumbnails.of((InputStream[])new InputStream[]{Streams.toInputStream(bs)});
    }

    public static ImageExecutorStream of(String name) {
        return new ImageExecutorStream(name);
    }

    public static ImageExecutorStream of(File file) {
        return new ImageExecutorStream(file);
    }

    public static ImageExecutorStream of(InputStream in) {
        return new ImageExecutorStream(in);
    }

    public static ImageExecutorStream of(byte[] bs) {
        return new ImageExecutorStream(bs);
    }

    public ImageExecutorStream size(int width, int height) {
        this.builder.size(width, height);
        return this;
    }

    public ImageExecutorStream width(int width) {
        this.builder.width(width);
        return this;
    }

    public ImageExecutorStream height(int height) {
        this.builder.height(height);
        return this;
    }

    public ImageExecutorStream rotate(double angle) {
        this.builder.rotate(angle);
        return this;
    }

    public ImageExecutorStream rotateLeft() {
        this.builder.rotate(-90.0);
        return this;
    }

    public ImageExecutorStream rotateRight() {
        this.builder.rotate(90.0);
        return this;
    }

    public ImageExecutorStream scale(double scale) {
        this.builder.scale(scale);
        return this;
    }

    public ImageExecutorStream keepAspectRatio(boolean keep) {
        this.builder.keepAspectRatio(keep);
        return this;
    }

    public ImageExecutorStream skipAspectRatio() {
        this.builder.keepAspectRatio(false);
        return this;
    }

    public ImageExecutorStream format(String format) {
        this.format = format;
        this.builder.outputFormat(format);
        return this;
    }

    public ImageExecutorStream quality(double quality) {
        this.builder.outputQuality(quality);
        return this;
    }

    public ImageExecutorStream overWrite(boolean overWrite) {
        this.builder.allowOverwrite(overWrite);
        return this;
    }

    public ImageExecutorStream unOverWrite() {
        this.builder.allowOverwrite(false);
        return this;
    }

    public ImageExecutorStream scalingMode(ScalingMode scalingMode) {
        this.builder.scalingMode(scalingMode);
        return this;
    }

    public ImageExecutorStream rendering(Rendering rendering) {
        this.builder.rendering(rendering);
        return this;
    }

    public ImageExecutorStream alphaInterpolation(AlphaInterpolation alphaInterpolation) {
        this.builder.alphaInterpolation(alphaInterpolation);
        return this;
    }

    public ImageExecutorStream antialias(Antialiasing antialias) {
        this.builder.antialiasing(antialias);
        return this;
    }

    public ImageExecutorStream dithering(Dithering dithering) {
        this.builder.dithering(dithering);
        return this;
    }

    public ImageExecutorStream watermark(byte[] bs) throws IOException {
        this.builder.watermark(ImageIO.read(Streams.toInputStream(bs)));
        return this;
    }

    public ImageExecutorStream watermark(File file) throws IOException {
        this.builder.watermark(ImageIO.read(file));
        return this;
    }

    public ImageExecutorStream watermark(InputStream in) throws IOException {
        this.builder.watermark(ImageIO.read(in));
        return this;
    }

    public ImageExecutorStream watermark(BufferedImage image) {
        this.builder.watermark(image);
        return this;
    }

    public ImageExecutorStream watermark(byte[] bs, float opacity) throws IOException {
        this.builder.watermark(ImageIO.read(Streams.toInputStream(bs)), opacity);
        return this;
    }

    public ImageExecutorStream watermark(File file, float opacity) throws IOException {
        this.builder.watermark(ImageIO.read(file), opacity);
        return this;
    }

    public ImageExecutorStream watermark(InputStream in, float opacity) throws IOException {
        this.builder.watermark(ImageIO.read(in), opacity);
        return this;
    }

    public ImageExecutorStream watermark(BufferedImage image, float opacity) {
        this.builder.watermark(image, opacity);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, byte[] bs) throws IOException {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), ImageIO.read(Streams.toInputStream(bs)), 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, File file) throws IOException {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), ImageIO.read(file), 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, InputStream in) throws IOException {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), ImageIO.read(in), 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, BufferedImage image) {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), image, 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, byte[] bs, float opacity) throws IOException {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), ImageIO.read(Streams.toInputStream(bs)), opacity);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, File file, float opacity) throws IOException {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), ImageIO.read(file), opacity);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, InputStream in, float opacity) throws IOException {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), ImageIO.read(in), opacity);
        return this;
    }

    public ImageExecutorStream watermark(int x, int y, BufferedImage image, float opacity) {
        this.builder.watermark((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point(x, y), image, opacity);
        return this;
    }

    public ImageExecutorStream watermark(Position p, byte[] bs) throws IOException {
        this.builder.watermark(p, ImageIO.read(Streams.toInputStream(bs)), 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(Position p, File file) throws IOException {
        this.builder.watermark(p, ImageIO.read(file), 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(Position p, InputStream in) throws IOException {
        this.builder.watermark(p, ImageIO.read(in), 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(Position p, BufferedImage image) {
        this.builder.watermark(p, image, 0.5f);
        return this;
    }

    public ImageExecutorStream watermark(Position p, byte[] bs, float opacity) throws IOException {
        this.builder.watermark(p, ImageIO.read(Streams.toInputStream(bs)), opacity);
        return this;
    }

    public ImageExecutorStream watermark(Position p, File file, float opacity) throws IOException {
        this.builder.watermark(p, ImageIO.read(file), opacity);
        return this;
    }

    public ImageExecutorStream watermark(Position p, InputStream in, float opacity) throws IOException {
        this.builder.watermark(p, ImageIO.read(in), opacity);
        return this;
    }

    public ImageExecutorStream watermark(Position p, BufferedImage image, float opacity) {
        this.builder.watermark(p, image, opacity);
        return this;
    }

    public ImageExecutorStream crop() {
        this.builder.crop((enclosingWidth, enclosingHeight, width, height, insetLeft, insetRight, insetTop, insetBottom) -> new Point());
        return this;
    }

    public ImageExecutorStream sourceRegion(int width, int height) {
        this.builder.sourceRegion(0, 0, width, height);
        return this;
    }

    public ImageExecutorStream sourceRegion(int x, int y, int width, int height) {
        this.builder.sourceRegion(x, y, width, height);
        return this;
    }

    public void execute(File file) throws IOException {
        this.builder.toFile(file);
    }

    public void execute(String file) throws IOException {
        this.builder.toFile(file);
    }

    public void execute(OutputStream out) throws IOException {
        this.builder.toOutputStream(out);
    }

    public BufferedImage getImage() throws IOException {
        return this.builder.asBufferedImage();
    }

    public String getBase64() throws IOException {
        if (this.format == null) {
            return Images.base64Encode(this.builder.asBufferedImage());
        }
        return Images.base64Encode(this.builder.asBufferedImage(), this.format);
    }

    public Thumbnails.Builder<?> getBuilder() {
        return this.builder;
    }
}

