/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.awt;

import com.orion.lang.able.Executable;
import com.orion.lang.utils.Colors;
import com.orion.lang.utils.awt.Images;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;

public class ImageDrawStream
implements Executable {
    private final Graphics2D g2d;

    public ImageDrawStream(BufferedImage image) {
        this(image.createGraphics());
    }

    public ImageDrawStream(Graphics2D g2d) {
        this.g2d = g2d;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static ImageDrawStream of(BufferedImage image) {
        return new ImageDrawStream(image);
    }

    public static ImageDrawStream of(Graphics2D g2d) {
        return new ImageDrawStream(g2d);
    }

    public ImageDrawStream insertImageBase64(String base64) {
        return this.insertImage(Images.getImageBase64(base64), 0, 0);
    }

    public ImageDrawStream insertImageBase64(String base64, int x, int y) {
        return this.insertImage(Images.getImageBase64(base64), x, y);
    }

    public ImageDrawStream insertImage(InputStream in) {
        return this.insertImage(Images.getImage(in), 0, 0);
    }

    public ImageDrawStream insertImage(InputStream in, int x, int y) {
        return this.insertImage(Images.getImage(in), x, y);
    }

    public ImageDrawStream insertImage(File file) {
        return this.insertImage(Images.getImage(file), 0, 0);
    }

    public ImageDrawStream insertImage(File file, int x, int y) {
        return this.insertImage(Images.getImage(file), x, y);
    }

    public ImageDrawStream insertImage(byte[] img) {
        return this.insertImage(Images.getImage(img), 0, 0);
    }

    public ImageDrawStream insertImage(byte[] img, int x, int y) {
        return this.insertImage(Images.getImage(img), x, y);
    }

    public ImageDrawStream insertImage(BufferedImage img) {
        return this.insertImage(img, 0, 0);
    }

    public ImageDrawStream insertImage(BufferedImage img, int x, int y) {
        this.g2d.drawImage(img, x, y, img.getWidth(), img.getHeight(), null);
        return this;
    }

    public ImageDrawStream insertString(String s, int x, int y) {
        this.g2d.drawString(s, x, y);
        return this;
    }

    public ImageDrawStream insertLine(int p1x, int p1y, int p2x, int p2y) {
        this.g2d.drawLine(p1x, p1y, p2x, p2y);
        return this;
    }

    public ImageDrawStream color(int r, int g, int b) {
        this.g2d.setColor(Colors.toColor(r, g, b));
        return this;
    }

    public ImageDrawStream color(String hex) {
        this.g2d.setColor(Colors.toColor(hex));
        return this;
    }

    public ImageDrawStream color(Color color) {
        this.g2d.setColor(color);
        return this;
    }

    public ImageDrawStream font(Font font) {
        this.g2d.setFont(font);
        return this;
    }

    public ImageDrawStream font(String name, int size) {
        this.g2d.setFont(new Font(name, 0, size));
        return this;
    }

    public ImageDrawStream font(String name) {
        this.g2d.setFont(new Font(name, 0, 18));
        return this;
    }

    public ImageDrawStream font(int size) {
        this.g2d.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, size));
        return this;
    }

    @Override
    public void exec() {
        this.g2d.dispose();
    }

    public Graphics2D getGraphics() {
        return this.g2d;
    }
}

