/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.font.FontDesignMetrics;

public class Fonts {
    private Fonts() {
    }

    public static FontMetrics getMetrics(Font font) {
        return FontDesignMetrics.getMetrics(font);
    }

    public static int getStringWidth(char c, Font font) {
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(font);
        return ((FontMetrics)fm).charWidth(c);
    }

    public static int getStringWidth(String s, Font font) {
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(font);
        return ((FontMetrics)fm).stringWidth(s);
    }

    public static int getHeight(Font font) {
        FontDesignMetrics fm = FontDesignMetrics.getMetrics(font);
        return ((FontMetrics)fm).getHeight();
    }

    public static String[] getSupportedFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static int[] getWidthHeightPixel(Graphics2D g2d, Font font, String s) {
        return Fonts.getWidthHeightPixel(g2d, font, s, 0, 0);
    }

    public static int[] getWidthHeightPixel(Graphics2D g2d, Font font, String s, int x, int y) {
        FontRenderContext context = g2d.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(context, s);
        Rectangle bounds = gv.getPixelBounds(null, x, y);
        return new int[]{bounds.width, bounds.height};
    }
}

