/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils;

import com.orion.lang.utils.Strings;

public class Safes {
    private static final String SAFE_CHAR = "*";

    private Safes() {
    }

    public static String mix(String s, int start, int end, String safe, int repeat) {
        int length = Strings.length(s);
        if (length == 0) {
            return "";
        }
        if (Strings.isBlank(safe)) {
            safe = SAFE_CHAR;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > length) {
            start = length;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > length) {
            end = length;
        }
        char[] chars = s.toCharArray();
        char[] safeChars = Strings.repeatArr(safe, repeat);
        char[] res = new char[start + (length - end) + safeChars.length];
        System.arraycopy(chars, 0, res, 0, start);
        System.arraycopy(safeChars, 0, res, start, safeChars.length);
        System.arraycopy(chars, end, res, start + safeChars.length, length - end);
        return new String(res);
    }

    public static String mixSurName(String s) {
        return Safes.mix(s, 0, 1, SAFE_CHAR, 1);
    }

    public static String mixName(String s) {
        int length = Strings.length(s);
        return Safes.mix(s, 1, length, SAFE_CHAR, length - 1);
    }

    public static String mixPhone(String s) {
        return Safes.mix(s, 3, 7, SAFE_CHAR, 4);
    }

    public static String mixCardNum(String s) {
        return Safes.mix(s, 6, 14, SAFE_CHAR, 8);
    }
}

