/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class References {
    private References() {
    }

    public static <T> Reference<T> create(ReferenceType type, T referent) {
        return References.create(type, referent, null);
    }

    public static <T> Reference<T> create(ReferenceType type, T referent, ReferenceQueue<T> queue) {
        switch (type) {
            case SOFT: {
                return new SoftReference<T>(referent);
            }
            case WEAK: {
                return new WeakReference<T>(referent);
            }
            case PHANTOM: {
                return new PhantomReference<T>(referent, queue);
            }
        }
        return null;
    }

    public static enum ReferenceType {
        SOFT,
        WEAK,
        PHANTOM;

    }
}

