/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils;

public class Chars {
    private Chars() {
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean isAsciiPrintable(char c) {
        return c >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    public static boolean isLetter(char c) {
        return Chars.isLetterUpper(c) || Chars.isLetterLower(c);
    }

    public static boolean isLetterUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLetterLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isHexChar(char c) {
        return Chars.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static boolean isBlankChar(char c) {
        return Chars.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static boolean isEmoji(char c) {
        return !(c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd');
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int getType(int c) {
        return Character.getType(c);
    }

    public static int digit16(char b) {
        return Character.digit(b, 16);
    }
}

