/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;

public class CharConverts {
    private static final String UNICODE_PREFIX = "\\u";
    private static final String HTML_ENTITY_PREFIX = "&#";
    private static final String HTML_ENTITY_SUFFIX = ";";

    private CharConverts() {
    }

    public static String toHtmlEntity(String str) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char c : chars = str.toCharArray()) {
            sb.append(HTML_ENTITY_PREFIX).append((int)c).append(HTML_ENTITY_SUFFIX);
        }
        return sb.toString();
    }

    public static String fromHtmlEntity(String value) {
        String[] chars;
        StringBuilder sb = new StringBuilder();
        for (String un : chars = value.split(HTML_ENTITY_SUFFIX)) {
            sb.append((char)Integer.parseInt(un.trim().substring(2)));
        }
        return sb.toString();
    }

    public static String toUnicode(String str) {
        return CharConverts.toUnicode(str, false);
    }

    public static String toUnicode(String str, boolean convertNumber) {
        char[] chars = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            if (convertNumber || c > '\u00ff') {
                sb.append(CharConverts.toUnicodeChar(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toUnicodeChar(char c) {
        StringBuilder sb = new StringBuilder();
        sb.append(UNICODE_PREFIX);
        int code = c >> 8;
        String tmp = Integer.toHexString(code);
        if (tmp.length() == 1) {
            sb.append("0");
        }
        sb.append(tmp);
        code = c & 0xFF;
        tmp = Integer.toHexString(code);
        if (tmp.length() == 1) {
            sb.append("0");
        }
        sb.append(tmp);
        return sb.toString();
    }

    public static String fromUnicode(String str) {
        StringBuilder sb = new StringBuilder();
        int begin = 0;
        int index = str.indexOf(UNICODE_PREFIX);
        while (index != -1) {
            sb.append(str, begin, index);
            sb.append(CharConverts.fromUnicodeChar(str.substring(index, index + 6)));
            begin = index + 6;
            index = str.indexOf(UNICODE_PREFIX, begin);
        }
        sb.append(str.substring(begin));
        return sb.toString();
    }

    public static char fromUnicodeChar(String str) {
        if (str.length() != 6) {
            throw Exceptions.argument("ascii string of a native character must be 6 character.");
        }
        if (!UNICODE_PREFIX.equals(str.substring(0, 2))) {
            throw Exceptions.argument("ascii string of a native character must start with \"\\u\".");
        }
        String tmp = str.substring(2, 4);
        int code = Integer.parseInt(tmp, 16) << 8;
        tmp = str.substring(4, 6);
        return (char)(code += Integer.parseInt(tmp, 16));
    }

    public static String toHex(String str) {
        return CharConverts.toHex(Strings.bytes(str));
    }

    public static String toHex(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bs) {
            sb.append(String.format("%%%02X", b));
        }
        return sb.toString();
    }

    public static String fromHex(String str) {
        return new String(CharConverts.fromHexByte(str));
    }

    public static byte[] fromHexByte(String str) {
        int l = str.length() / 3;
        byte[] ret = new byte[l];
        for (int i = 0; i < l; ++i) {
            ret[i] = Integer.valueOf(str.substring(i * 3 + 1, i * 3 + 3), 16).byteValue();
        }
        return ret;
    }
}

