/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.id;

import com.orion.lang.able.IdGenerator;
import com.orion.lang.utils.Exceptions;

public class SnowFlakeIdWorker
implements IdGenerator<Long> {
    private static final long START_TIME = 1489111610226L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw Exceptions.argument(String.format("workerId can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw Exceptions.argument(String.format("dataCenterId can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    @Override
    public synchronized Long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw Exceptions.runtime(String.format("clock moved backwards. refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1489111610226L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

