/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.id;

import com.orion.lang.able.IdGenerator;
import com.orion.lang.define.SystemClock;
import com.orion.lang.utils.Exceptions;
import java.util.concurrent.ThreadLocalRandom;

public class SequenceIdWorker
implements IdGenerator<Long> {
    private static final long START_TIME = 7L;
    private static final long DATA_CENTER_ID_BITS = 2L;
    private static final long WORKER_ID_BITS = 8L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_WORKER_ID = 255L;
    private static final long MAX_DATA_CENTER_ID = 3L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 20L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence;
    private long lastTimestamp = -1L;
    private final boolean clock;
    private final long timeOffset;
    private final boolean randomSequence;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    public SequenceIdWorker(long dataCenterId, long workerId) {
        this(dataCenterId, workerId, false, 5L, false);
    }

    public SequenceIdWorker(long dataCenterId, long workerId, boolean clock, boolean randomSequence) {
        this(dataCenterId, workerId, clock, 5L, randomSequence);
    }

    public SequenceIdWorker(long dataCenterId, long workerId, boolean clock, long timeOffset, boolean randomSequence) {
        if (dataCenterId > 3L || dataCenterId < 0L) {
            throw Exceptions.argument("data center id can't be greater than 3 or less than 0");
        }
        if (workerId > 255L || workerId < 0L) {
            throw Exceptions.argument("worker id can't be greater than 255 or less than 0");
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.clock = clock;
        this.timeOffset = timeOffset;
        this.randomSequence = randomSequence;
    }

    @Override
    public synchronized Long nextId() {
        long currentTimestamp = this.timeGen();
        if (currentTimestamp < this.lastTimestamp) {
            long offset = this.lastTimestamp - currentTimestamp;
            if (offset > this.timeOffset) {
                throw Exceptions.runtime("clock moved backwards, refusing to generate id for [" + offset + "ms]");
            }
            try {
                this.wait(offset << 1);
            }
            catch (Exception e) {
                throw Exceptions.runtime(e);
            }
            currentTimestamp = this.timeGen();
            if (currentTimestamp < this.lastTimestamp) {
                throw Exceptions.runtime("clock moved backwards, refusing to generate id for [" + offset + "ms]");
            }
        }
        if (this.lastTimestamp == currentTimestamp) {
            long tempSequence = this.sequence + 1L;
            if (this.randomSequence && tempSequence > 4095L) {
                tempSequence %= 4095L;
            }
            this.sequence = tempSequence & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = this.randomSequence ? this.random.nextLong(4096L) : 0L;
        }
        this.lastTimestamp = currentTimestamp;
        long currentOffsetTime = currentTimestamp - 7L;
        return currentOffsetTime << 22 | this.dataCenterId << 20 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return this.clock ? SystemClock.now() : System.currentTimeMillis();
    }
}

