/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.wrapper;

import com.orion.lang.KitLangConfiguration;
import com.orion.lang.able.ILogObject;
import com.orion.lang.able.IMapObject;
import com.orion.lang.config.KitConfig;
import com.orion.lang.define.support.CloneSupport;
import com.orion.lang.define.wrapper.Wrapper;
import com.orion.lang.utils.json.Jsons;
import java.util.HashMap;
import java.util.Map;

public class UrlWrapper<T>
extends CloneSupport<UrlWrapper<T>>
implements Wrapper<T>,
ILogObject,
IMapObject<String, Object> {
    private static final long serialVersionUID = 4250545197688197L;
    public static final Integer URL_NO_OPERATION = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.URL_NO_OPERATION);
    public static final Integer URL_REFRESH = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.URL_REFRESH);
    public static final Integer URL_REDIRECT = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.URL_REDIRECT);
    private String url;
    private int type;
    private T data;

    private UrlWrapper() {
    }

    private UrlWrapper(String url) {
        this.url = url;
    }

    private UrlWrapper(String url, int type) {
        this.url = url;
        this.type = type;
    }

    private UrlWrapper(String url, T data) {
        this.url = url;
        this.data = data;
    }

    private UrlWrapper(String url, int type, T data) {
        this.url = url;
        this.type = type;
        this.data = data;
    }

    public static <T> UrlWrapper<T> get() {
        return new UrlWrapper<Object>("", URL_NO_OPERATION, null);
    }

    public static <T> UrlWrapper<T> get(T data) {
        return new UrlWrapper<T>("", URL_NO_OPERATION, data);
    }

    public static <T> UrlWrapper<T> refresh() {
        return new UrlWrapper<Object>("", URL_REFRESH, null);
    }

    public static <T> UrlWrapper<T> refresh(T data) {
        return new UrlWrapper<T>("", URL_REFRESH, data);
    }

    public static <T> UrlWrapper<T> redirect() {
        return new UrlWrapper<Object>("", URL_REDIRECT, null);
    }

    public static <T> UrlWrapper<T> redirect(String url) {
        return new UrlWrapper<Object>(url, URL_REDIRECT, null);
    }

    public static <T> UrlWrapper<T> redirect(String url, T data) {
        return new UrlWrapper<T>(url, URL_REDIRECT, data);
    }

    public UrlWrapper<T> url(String url) {
        this.url = url;
        return this;
    }

    public UrlWrapper<T> type(int type) {
        this.type = type;
        return this;
    }

    public UrlWrapper<T> data(T data) {
        this.data = data;
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getUrl() {
        return this.url;
    }

    public int getType() {
        return this.type;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return this.toLogString();
    }

    @Override
    public String toLogString() {
        return "UrlWrapper:\n   url ==> " + this.url + "\n  type ==> " + this.type + "\n  data ==> " + Jsons.toJsonWriteNull(this.data);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("url", this.url);
        map.put("type", this.type);
        map.put("data", this.data);
        return map;
    }
}

