/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.wrapper;

import com.orion.lang.define.support.CloneSupport;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

public class Pair<K, V>
extends CloneSupport<Pair<K, V>>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 3797556461612462L;
    private K key;
    private V value;

    public Pair() {
    }

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public Pair(Map.Entry<K, V> entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public static <K, V> Pair<K, V> of(Map.Entry<K, V> entry) {
        return new Pair<K, V>(entry);
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    public V setValue(V value) {
        this.value = value;
        return value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public Optional<K> keyOptional() {
        return Optional.ofNullable(this.key);
    }

    public Optional<V> valueOptional() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        Object v;
        Map.Entry e;
        Object k;
        return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !k.equals(this.key) || v != this.value && !v.equals(this.value));
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

