/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.wrapper;

import com.alibaba.fastjson.annotation.JSONField;
import com.orion.lang.KitLangConfiguration;
import com.orion.lang.able.ILogObject;
import com.orion.lang.able.IMapObject;
import com.orion.lang.config.KitConfig;
import com.orion.lang.define.support.CloneSupport;
import com.orion.lang.define.wrapper.CodeInfo;
import com.orion.lang.define.wrapper.RpcWrapper;
import com.orion.lang.define.wrapper.Wrapper;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HttpWrapper<T>
extends CloneSupport<HttpWrapper<T>>
implements Wrapper<T>,
ILogObject,
IMapObject<String, Object> {
    private static final long serialVersionUID = 7048691672612601L;
    public static final Integer HTTP_OK_CODE = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_OK_CODE);
    public static final String HTTP_OK_MESSAGE = (String)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_OK_MESSAGE);
    public static final Integer HTTP_ERROR_CODE = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_ERROR_CODE);
    public static final String HTTP_ERROR_MESSAGE = (String)KitConfig.get(KitLangConfiguration.CONFIG.HTTP_ERROR_MESSAGE);
    @JSONField(ordinal=0)
    private int code;
    @JSONField(ordinal=1)
    private String msg;
    @JSONField(ordinal=2)
    private T data;

    public HttpWrapper() {
        this(HTTP_OK_CODE, HTTP_OK_MESSAGE, null);
    }

    public HttpWrapper(int code) {
        this(code, HTTP_OK_MESSAGE, null);
    }

    public HttpWrapper(int code, String msg) {
        this(code, msg, null);
    }

    public HttpWrapper(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public HttpWrapper(CodeInfo info) {
        this(info.code(), info.message(), null);
    }

    public HttpWrapper(CodeInfo info, T data) {
        this(info.code(), info.message(), data);
    }

    public static <T> HttpWrapper<T> get() {
        return new HttpWrapper<T>();
    }

    public static <T> HttpWrapper<T> of(CodeInfo info) {
        return new HttpWrapper<T>(info.code(), info.message());
    }

    public static <T> HttpWrapper<T> of(CodeInfo info, T data) {
        return new HttpWrapper<T>(info.code(), info.message(), data);
    }

    public static <T> HttpWrapper<T> of(int code, String msg) {
        return new HttpWrapper<T>(code, msg);
    }

    public static <T> HttpWrapper<T> of(int code, String msg, T data) {
        return new HttpWrapper<T>(code, msg, data);
    }

    public static <T> HttpWrapper<T> ok() {
        return new HttpWrapper<T>(HTTP_OK_CODE, HTTP_OK_MESSAGE);
    }

    public static <T> HttpWrapper<T> ok(T data) {
        return new HttpWrapper<T>(HTTP_OK_CODE, HTTP_OK_MESSAGE, data);
    }

    public static <T> HttpWrapper<T> error() {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, HTTP_ERROR_MESSAGE);
    }

    public static <T> HttpWrapper<T> error(int code) {
        return new HttpWrapper<T>(code, HTTP_ERROR_MESSAGE);
    }

    public static <T> HttpWrapper<T> error(String msg) {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, msg);
    }

    public static <T> HttpWrapper<T> error(String msg, Object ... params) {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, Strings.format(msg, params));
    }

    public static <T> HttpWrapper<T> error(int code, String msg) {
        return new HttpWrapper<T>(code, msg);
    }

    public static <T> HttpWrapper<T> error(int code, String msg, Object ... params) {
        return new HttpWrapper<T>(code, Strings.format(msg, params));
    }

    public static <T> HttpWrapper<T> error(Throwable t) {
        return new HttpWrapper<T>(HTTP_ERROR_CODE, t.getMessage());
    }

    public static <T> HttpWrapper<T> error(int code, Throwable t) {
        return new HttpWrapper<T>(code, t.getMessage());
    }

    public HttpWrapper<T> code(int code) {
        this.code = code;
        return this;
    }

    public HttpWrapper<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public HttpWrapper<T> data(T data) {
        this.data = data;
        return this;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    @JSONField(serialize=false)
    public boolean isOk() {
        return HTTP_OK_CODE.equals(this.code);
    }

    public String toString() {
        return this.toLogString();
    }

    @Override
    public String toLogString() {
        return "HttpWrapper:\n  code ==> " + this.code + "\n   msg ==> " + this.msg + "\n  data ==> " + Objects1.toString(this.data);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("code", this.code);
        map.put("msg", this.msg);
        map.put("data", this.data);
        return map;
    }

    public RpcWrapper<T> toRpcWrapper() {
        return new RpcWrapper<T>(this.code, this.msg, this.data);
    }

    public Optional<T> optional() {
        return Optional.of(this).filter(HttpWrapper::isOk).map(HttpWrapper::getData);
    }
}

