/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.wrapper;

import com.alibaba.fastjson.annotation.JSONField;
import com.orion.lang.KitLangConfiguration;
import com.orion.lang.able.IJsonObject;
import com.orion.lang.config.KitConfig;
import com.orion.lang.define.iterator.EmptyIterator;
import com.orion.lang.define.support.CloneSupport;
import com.orion.lang.define.wrapper.Pager;
import com.orion.lang.utils.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class DataGrid<T>
extends CloneSupport<DataGrid<T>>
implements Serializable,
IJsonObject,
Iterable<T> {
    private static final long serialVersionUID = 3787662930250625L;
    private static final int DEFAULT_LIMIT = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.DATA_GRID_DEFAULT_LIMIT);
    @JSONField(ordinal=0)
    private int page;
    @JSONField(ordinal=1)
    private int limit;
    @JSONField(ordinal=2)
    private int size;
    @JSONField(ordinal=3)
    private int pages;
    @JSONField(ordinal=4)
    private int total;
    @JSONField(ordinal=5)
    private List<T> rows;

    public DataGrid() {
    }

    public DataGrid(List<T> rows) {
        this(rows, Lists.size(rows));
    }

    public DataGrid(List<T> rows, int total) {
        this.page = 1;
        this.limit = DEFAULT_LIMIT;
        this.rows = rows;
        this.size = Lists.size(this.rows);
        this.total = total;
        if (total != 0) {
            this.pages = total % this.limit == 0 ? total / this.limit : total / this.limit + 1;
        }
    }

    public DataGrid(Pager<T> pager) {
        this.rows = pager.getRows();
        this.total = pager.getTotal();
        this.pages = pager.getPages();
        this.page = pager.getPage();
        this.limit = pager.getLimit();
        this.size = Lists.size(this.rows);
    }

    public static <T> DataGrid<T> of() {
        return new DataGrid<T>();
    }

    public static <T> DataGrid<T> of(List<T> rows) {
        return new DataGrid<T>(rows);
    }

    public static <T> DataGrid<T> of(List<T> rows, int total) {
        return new DataGrid<T>(rows, total);
    }

    public static <T> DataGrid<T> of(Pager<T> pager) {
        return new DataGrid<T>(pager);
    }

    public DataGrid<T> addRow(T row) {
        if (row == null) {
            return this;
        }
        if (this.rows == null) {
            this.rows = new ArrayList<T>();
        }
        this.rows.add(row);
        ++this.size;
        this.setTotal(this.total + 1);
        return this;
    }

    public DataGrid<T> addRows(List<T> rows) {
        int size;
        if (this.rows == null) {
            this.rows = new ArrayList<T>();
        }
        if ((size = Lists.size(rows)) > 0) {
            this.rows.addAll(rows);
            this.size += size;
            this.setTotal(this.total + size);
        }
        return this;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
        if (rows != null) {
            this.size = rows.size();
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
        if (total != 0) {
            this.pages = total % this.limit == 0 ? total / this.limit : total / this.limit + 1;
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.setTotal(this.total);
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public DataGrid<T> resetPages() {
        if (this.total != 0) {
            this.pages = this.total % this.limit == 0 ? this.total / this.limit : this.total / this.limit + 1;
        }
        return this;
    }

    public boolean hasNextPage() {
        return this.pages > this.page;
    }

    @JSONField(serialize=false)
    public boolean isEmpty() {
        return Lists.isEmpty(this.rows);
    }

    @JSONField(serialize=false)
    public boolean isNotEmpty() {
        return Lists.isNotEmpty(this.rows);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.rows.stream();
    }

    public String toString() {
        return String.valueOf(this.rows);
    }

    @Override
    public Iterator<T> iterator() {
        if (!this.isEmpty()) {
            return this.rows.iterator();
        }
        return new EmptyIterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        if (!this.isEmpty()) {
            this.rows.forEach(action);
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.rows.spliterator();
    }
}

