/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.thread;

import com.orion.lang.define.wrapper.Tuple;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TaskCollector {
    private final ExecutorService dispatch;
    private Future<?>[] futures;

    public TaskCollector(ExecutorService dispatch) {
        Valid.notNull(dispatch, "task dispatch is null", new Object[0]);
        this.dispatch = dispatch;
    }

    public TaskCollector tasks(Callable<?> ... tasks) {
        this.futures = new Future[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            Callable<?> task = tasks[i];
            try {
                this.futures[i] = this.dispatch.submit(task);
                continue;
            }
            catch (Exception e) {
                throw Exceptions.task("an exception occurred while the task was running", e);
            }
        }
        return this;
    }

    public Tuple collect() {
        Object[] result = new Object[this.futures.length];
        for (int i = 0; i < this.futures.length; ++i) {
            Future<?> future = this.futures[i];
            try {
                result[i] = future.get();
                continue;
            }
            catch (InterruptedException e) {
                throw Exceptions.task("collect result timeout", e);
            }
            catch (Exception e) {
                throw Exceptions.task("collect result error", e);
            }
        }
        return Tuple.of(result);
    }
}

