/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.thread;

import java.util.Objects;
import java.util.function.Supplier;

public class NamedThreadLocal<T>
extends ThreadLocal<T> {
    private final String name;

    public NamedThreadLocal(String name) {
        this.name = name;
    }

    public static <S> NamedThreadLocal<S> withInitial(String name, Supplier<? extends S> supplier) {
        return new SuppliedThreadLocal<S>(name, supplier);
    }

    public String toString() {
        return this.name;
    }

    static final class SuppliedThreadLocal<T>
    extends NamedThreadLocal<T> {
        private final Supplier<? extends T> supplier;

        SuppliedThreadLocal(String name, Supplier<? extends T> supplier) {
            super(name);
            this.supplier = Objects.requireNonNull(supplier);
        }

        @Override
        protected T initialValue() {
            return this.supplier.get();
        }
    }
}

