/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.thread;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;

public class ConcurrentRunnable
implements Runnable {
    private final Runnable r;
    private CyclicBarrier cb;
    private CountDownLatch cd;

    public ConcurrentRunnable(Runnable r, CyclicBarrier cb) {
        Valid.notNull(r, "runnable is null", new Object[0]);
        Valid.notNull(cb, "cyclicBarrier is null", new Object[0]);
        this.r = r;
        this.cb = cb;
    }

    public ConcurrentRunnable(Runnable r, CountDownLatch cd) {
        Valid.notNull(r, "runnable is null", new Object[0]);
        Valid.notNull(cd, "countDownLatch is null", new Object[0]);
        this.r = r;
        this.cd = cd;
    }

    @Override
    public void run() {
        try {
            if (this.cb != null) {
                this.cb.await();
            } else if (this.cd != null) {
                this.cd.await();
            }
        }
        catch (Exception e) {
            throw Exceptions.task(e);
        }
        this.r.run();
    }
}

