/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.loader;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.reflect.Classes;
import com.orion.lang.utils.reflect.Methods;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, Classes.getCurrentClassLoader());
    }

    public static JarClassLoader load(File file) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(file);
        return loader;
    }

    public static URLClassLoader loadJar(File file) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, file);
        return urlClassLoader;
    }

    public static void loadJar(URLClassLoader loader, File file) {
        try {
            Method method = Methods.getAccessibleMethod(URLClassLoader.class, "addURL", URL.class);
            if (method != null) {
                Methods.invokeMethod((Object)loader, method, file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw Exceptions.load(e);
        }
    }

    public JarClassLoader addJar(String file) {
        Valid.notBlank(file, "file path is empty", new Object[0]);
        return this.addJar(new File(file));
    }

    public JarClassLoader addJar(File file) {
        Valid.notNull(file, "jar file is null", new Object[0]);
        if (!JarClassLoader.isJarFile(file)) {
            throw Exceptions.load("file is not jar file");
        }
        this.addURL(Files1.toUrl(file));
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    private static boolean isJarFile(File file) {
        if (!Files1.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }
}

