/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.iterator;

import com.orion.lang.utils.Valid;
import java.io.Serializable;
import java.util.Iterator;

public class ClassIterator<T>
implements Iterator<Class<? super T>>,
Iterable<Class<? super T>>,
Serializable {
    private final Class<T> clazz;
    private Class<? super T> current;
    private final boolean includeObject;

    public ClassIterator(Class<T> clazz) {
        this(clazz, false);
    }

    public ClassIterator(Class<T> clazz, boolean includeObject) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        this.clazz = clazz;
        this.current = this.clazz;
        this.includeObject = includeObject;
    }

    @Override
    public boolean hasNext() {
        if (this.clazz.getName().contains("$$")) {
            return false;
        }
        this.current = this.current.getSuperclass();
        if (this.current == null) {
            return false;
        }
        return this.includeObject || !Object.class.equals(this.current);
    }

    @Override
    public Class<? super T> next() {
        return this.current;
    }

    @Override
    public Iterator<Class<? super T>> iterator() {
        return this;
    }
}

