/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.io;

import com.orion.lang.support.progress.ByteTransferProgress;
import com.orion.lang.utils.Valid;
import java.io.IOException;
import java.io.Writer;

public class ProgressWriter
extends Writer {
    private final Writer wrapper;
    private ByteTransferProgress progress;

    public ProgressWriter(Writer wrapper) {
        this(wrapper, new ByteTransferProgress(0L));
    }

    public ProgressWriter(Writer wrapper, long end) {
        this(wrapper, new ByteTransferProgress(end));
    }

    public ProgressWriter(Writer wrapper, ByteTransferProgress progress) {
        this.wrapper = Valid.notNull(wrapper, "wrapper writer is null", new Object[0]);
        this.progress = progress;
    }

    @Override
    public void write(int c) throws IOException {
        this.wrapper.write(c);
        this.progress.accept(1L);
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.wrapper.write(chars);
        this.progress.accept(chars.length);
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        this.wrapper.write(chars);
        this.progress.accept(len);
    }

    @Override
    public void write(String str) throws IOException {
        this.wrapper.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.wrapper.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.wrapper.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.wrapper.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.wrapper.append(c);
    }

    @Override
    public void flush() throws IOException {
        this.wrapper.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrapper.close();
        this.progress.finish();
    }

    public void start() {
        this.progress.start();
    }

    public void finish() {
        this.finish(false);
    }

    public void finish(boolean error) {
        this.progress.finish(error);
    }

    public ByteTransferProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ByteTransferProgress progress) {
        this.progress = progress;
    }
}

