/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.io;

import com.orion.lang.support.progress.ByteTransferProgress;
import com.orion.lang.utils.Valid;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class ProgressReader
extends Reader {
    private final Reader wrapper;
    private ByteTransferProgress progress;

    public ProgressReader(Reader wrapper) {
        this(wrapper, new ByteTransferProgress(0L));
    }

    public ProgressReader(Reader wrapper, long end) {
        this(wrapper, new ByteTransferProgress(end));
    }

    public ProgressReader(Reader wrapper, ByteTransferProgress progress) {
        this.wrapper = Valid.notNull(wrapper, "wrapper reader is null", new Object[0]);
        this.progress = progress;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.wrapper.read(target);
    }

    @Override
    public int read() throws IOException {
        int read = this.wrapper.read();
        if (read != -1) {
            this.progress.accept(read);
        }
        return read;
    }

    @Override
    public int read(char[] chars) throws IOException {
        int read = this.wrapper.read(chars);
        if (read != -1) {
            this.progress.accept(read);
        }
        return read;
    }

    @Override
    public int read(char[] chars, int off, int len) throws IOException {
        int read = this.wrapper.read(chars, off, len);
        if (read != -1) {
            this.progress.accept(read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.wrapper.skip(n);
        this.progress.accept(skip);
        return skip;
    }

    @Override
    public boolean ready() throws IOException {
        return this.wrapper.ready();
    }

    @Override
    public boolean markSupported() {
        return this.wrapper.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.wrapper.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.wrapper.reset();
        this.progress.reset();
    }

    @Override
    public void close() throws IOException {
        this.wrapper.close();
        this.progress.finish();
    }

    public void start() {
        this.progress.start();
    }

    public void finish() {
        this.finish(false);
    }

    public void finish(boolean error) {
        this.progress.finish(error);
    }

    public ByteTransferProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ByteTransferProgress progress) {
        this.progress = progress;
    }
}

