/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.io;

import com.orion.lang.support.progress.ByteTransferProgress;
import com.orion.lang.utils.Valid;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends InputStream {
    private final InputStream wrapper;
    private ByteTransferProgress progress;

    public ProgressInputStream(InputStream wrapper) {
        this(wrapper, new ByteTransferProgress(0L));
    }

    public ProgressInputStream(InputStream wrapper, long end) {
        this(wrapper, new ByteTransferProgress(end));
    }

    public ProgressInputStream(InputStream wrapper, ByteTransferProgress progress) {
        this.wrapper = Valid.notNull(wrapper, "wrapper input stream is null", new Object[0]);
        this.progress = progress;
    }

    @Override
    public int read() throws IOException {
        int read = this.wrapper.read();
        if (read != -1) {
            this.progress.accept(1L);
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.wrapper.read(b);
        if (read != -1) {
            this.progress.accept(read);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.wrapper.read(b, off, len);
        if (read != -1) {
            this.progress.accept(read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.wrapper.skip(n);
        this.progress.accept(skip);
        return skip;
    }

    @Override
    public int available() throws IOException {
        return this.wrapper.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapper.close();
        this.progress.finish();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.wrapper.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapper.reset();
        this.progress.reset();
    }

    @Override
    public boolean markSupported() {
        return this.wrapper.markSupported();
    }

    public void start() {
        this.progress.start();
    }

    public void finish() {
        this.finish(false);
    }

    public void finish(boolean error) {
        this.progress.finish(error);
    }

    public ByteTransferProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ByteTransferProgress progress) {
        this.progress = progress;
    }
}

